/**
 * 
 */
package com.ericsson.cms.me.client.view.custom;

import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author AnujJain
 *
 */
public class ErrorPanel extends SimpleContainer{
	private String ERROR_MESSAGE_STYLE 			= "me-ValidationView-error ";
    private String SECTION_HEADING1_STYLE 		= "me-ValidationView-sectionHeading1";
    private String SECTION_HEADING2_STYLE 		= "me-ValidationView-sectionHeading2";
    private String PANEL_STYLE 					= "me-ValidationView";
    private int PANEL_SPACING = 5;

    protected VerticalContainer mainContainer;
    private VerticalContainer messageContainer;



    public ErrorPanel() {
        super();

        mainContainer = new VerticalContainer();
        mainContainer.addStyleName( PANEL_STYLE );
        mainContainer.addStyleName( ERROR_MESSAGE_STYLE );
        mainContainer.setSpacing( PANEL_SPACING );
        // or else border doesn't show up
        mainContainer.setVisible( false );

        messageContainer = new VerticalContainer();
        mainContainer.add( messageContainer );

        add( mainContainer );
    }

    /**
     * Sets the message text with the given value.
     * 
     * @param message
     */
    public void showMessage( String message ) {
        messageContainer.clear();
        addMessage( message );
    }

    public void showErrorHeader(String header){
    	messageContainer.clear();
    	addHeading1(header + "\n");
    }
    
    /**
     * Adds the message text with the given value.
     * 
     * @param message
     */
    public void addMessage( String message ) {
        if ( ( message != null ) && ( !message.trim().equals( "" ) ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "", message, SECTION_HEADING1_STYLE ) );
        }
    }

    /**
     * Adds the heading level 1 text with the given value.
     * 
     * @param message
     */
    public void addHeading1( String message ) {
        if ( ( message != null ) && ( !message.trim().equals( "" ) ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "", message, SECTION_HEADING1_STYLE ) );
        }
    }

    /**
     * Adds the heading level 2 text with the given value.
     * 
     * @param message
     */
    public void addHeading2( String message ) {
        if ( ( message != null ) && ( !message.trim().equals( "" ) ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "- ", message, SECTION_HEADING2_STYLE ) );
        }
    }


    public void addError( String message ) {
        if ( ( message != null ) && ( !message.trim().equals( "" ) ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "- ", message, SECTION_HEADING2_STYLE ) );
        }
    }
    
    public void addErrors(List<String> errors){
    	addHeading1("Errors(" + errors.size() + ")");
    	for(String curError : errors){
    		addError("\t" + curError + "");
    	}
    }
    
    private LabelWidget createMessageLabel( String prefix, String message, String style ) {
        LabelWidget messageLabel = new LabelWidget();

        messageLabel.setText( prefix + message );
        messageLabel.addStyleName( style );
        messageLabel.addStyleName( ERROR_MESSAGE_STYLE );
        messageLabel.setWordWrap( true );
        return messageLabel;
    }

    /**
     * Clears the text in all contained widgets.
     * 
     */
    public void reset() {
        messageContainer.clear();
        mainContainer.setVisible( false );
    }

}
