/**
 * 
 */
package com.ericsson.cms.me.client.view.custom;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

/**
 * 
 * A simple custom table widget
 *  
 * @author AnujJain
 *
 */
public class MECustomTableWidget extends Composite{

	/* Styles */
	private static final String TABLE_STYLE 					= "me-ConflictResultTable";
	private static final String ROW_STYLE 						= "me-ConflictResultTable-row";
	private static final String ROW_HEADER_STYLE 				= "me-ConflictResultTable-row-header";
	private static final String ROW_BODY_STYLE 					= "me-ConflictResultTable-row-body";
	private static final String CELL_STYLE 						= "me-ConflictResultTable-cell";
	private static final String CELL_HEADER_STYLE 				= "me-ConflictResultTable-cell-header";
	private static final String CELL_BODY_STYLE 				= "me-ConflictResultTable-cell-body";
	private static final String CELL_HEADER_LABEL_STYLE 		= "me-ConflictResultTable-header-text";
	public static final String CELL_DELETE_COLUMN_STYLE 		= "me-ConflictResultTable-cell-body-delete";
	
	private FlexTableContainer table = new FlexTableContainer();
	
	
	public MECustomTableWidget(){
		initialize();
	}
	
	/**
	 * Get the table used by the widget
	 * 
	 * @return The table
	 */
	public FlexTableContainer getTable() {
		return table;
	}
	
	
	/**
	 * initialize the table
	 * 
	 * */
	public void initialize() {
		table.addStyleName(TABLE_STYLE);

		/* Create the header row */
		table.insertRow(0);
		table.getRowFormatter().addStyleName(0, ROW_STYLE);
		table.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
		this.initWidget(table);
	}
	
	
	public void addHeading(String heading) {
		/* Add the column to the header row */
		int column = table.getCellCount(0);
		table.insertCell(0, column);

		/* Update the style of the header cells */
		table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
		table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);

		updateHeading(heading, column);
	}
	
	/**
	 * Update an existing cell content in the table header row
	 * 
	 * @param heading The header text
	 * @param column The column index
	 */
	public void updateHeading(String heading, int column) {
		/* Create new label widget or update existing widget */
		LabelWidget label = getHeadingWidget(column);
		if (label == null) {
			/* Update the widget displayed as the column header */
			label = new LabelWidget(heading);
			label.addStyleName(CELL_HEADER_LABEL_STYLE);
			table.setWidget(0, column, label);
		} else {
			label.setText(heading);
		}
	}
	
	/**
	 * Get the label widget used to represent the header cell
	 * 
	 * @return The header label
	 */
	public LabelWidget getHeadingWidget(int column) {
		Widget widget = table.getWidget(0, column);
		return (widget instanceof LabelWidget) ? (LabelWidget) widget : null;
	}
	
	/*
	 * Ensure that the row index is not less than 0
	 */
	private void validateBodyRow(int row) {
		if (row < 0) {
			throw new IllegalArgumentException("The row index cannot be less than 0.");
		}
	}
	
	
	/**
	 * Add a new row to the table at the specified index. The index cannot exceed the row count
	 * 
	 * @param row The row index
	 * @return The index of the newly created row
	 */
	public int addRow(int row) {
		validateBodyRow(row);

		/* Shift the row index to account for the header row */
		int tableRow = row + 1;
		table.insertRow(tableRow);
		table.getRowFormatter().addStyleName(tableRow, ROW_STYLE);
		table.getRowFormatter().addStyleName(tableRow, ROW_BODY_STYLE);

		return row;
	}
	
	public int addRow() {
		/* Add a row to the end of the table body (do not count the header row) */
		return this.addRow(getRowCount());
	}
	
	
	/**
	 * Returns a count of the rows in the table body
	 * 
	 * @return The row count
	 */
	public int getRowCount() {
		return table.getRowCount() - 1;
	}
	
	
	/**
	 * Get the cell count for a row in the table
	 * 
	 * @param row The row index
	 * @return the number of cells for the row
	 */
	public int getCellCount(int row) {
		return table.getCellCount(row + 1);
	}
	
	
	/**
	 * Add a new cell to the table body using the provided widget
	 */
	public void addCell(int row, Widget widget) {
		this.addCell(row, getCellCount(row), widget);
	}

	/**
	 * Add a new cell to the table using the provided widget at the specified column index
	 * 
	 * @param row The row index
	 * @param column The column index
	 * @param widget The widget to add
	 */
	public void addCell(int row, int column, Widget widget) {
		int tableRow = row + 1;
		table.insertCell(tableRow, column);

		/* Update the style of the body cell */
		table.getCellFormatter().addStyleName(tableRow, column, CELL_STYLE);
		table.getCellFormatter().addStyleName(tableRow, column, CELL_BODY_STYLE);

		updateCell(row, column, widget);
	}

	
	/**
	 * Replace the existing widget in the provided cell
	 * 
	 * @param row The
	 * @param column
	 * @param widget
	 */
	public void updateCell(int row, int column, Widget widget) {
		int tableRow = row + 1;
		table.clearCell(tableRow, column);
		table.setWidget(tableRow, column, widget);
	}
	
	
	/**
	 * Remove all rows from the table without affecting the table header
	 */
	public void removeAllRows() {
		int rowCount = this.getRowCount();
		for (int i = rowCount - 1; i >= 0; i--) {
			this.removeRow(i);
		}
	}
	
	
	/**
	 * Remove an existing row from the table
	 * 
	 * @param row The row index
	 */
	public void removeRow(int row) {
		validateBodyRow(row);
		table.removeRow(row + 1);
	}
}
