/**
 * 
 */
package com.ericsson.cms.me.client.view.custom;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author AnujJain
 * 
 */
public class SuccessPanel extends SimpleContainer{

	private VerticalContainer mainContainer;
	private VerticalContainer messageContainer;
	private String SUCCESS_MESSAGE_STYLE1 = "me-success-message-1";
	private String PANEL_STYLE = "me-SuccessPanel";
	private int PANEL_SPACING = 5;
	public SuccessPanel() {
		super();
		mainContainer = new VerticalContainer();
		
        mainContainer.addStyleName( PANEL_STYLE );
        mainContainer.setSpacing( PANEL_SPACING );
        // or else border doesn't show up
        mainContainer.setVisible( false );

        messageContainer = new VerticalContainer();
        mainContainer.add( messageContainer );

        add( mainContainer );		
	}

	private LabelWidget createMessageLabel(String message) {
		LabelWidget messageLabel = new LabelWidget();

		messageLabel.setText(message);
		messageLabel.addStyleName(SUCCESS_MESSAGE_STYLE1);
		messageLabel.setWordWrap(true);

		return messageLabel;
	}

	/**
	 * Sets the message text with the given value.
	 * 
	 * @param message
	 */
	public void showMessage(String message) {
		messageContainer.clear();
		if ((message != null) && (!message.trim().equals(""))) {
			mainContainer.setVisible(true);
			messageContainer.add(createMessageLabel(message));
		}
	}

	/**
	 * Adds the message text with the given value.
	 * 
	 * @param message
	 */
	public void addMessage(String message) {
		messageContainer.add(createMessageLabel(message));
	}

	/**
	 * Clears the text in all contained widgets.
	 * 
	 */
	public void reset() {
		messageContainer.clear();
		mainContainer.setVisible(false);
	}
}
