/**
 * 
 */
package com.ericsson.cms.me.client.view.metadatadeconflict;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.UiCacheResult;
import com.ericsson.cms.me.client.model.UiCacheResultStatus;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.custom.MECustomTableWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author AnujJain
 *
 */
public class MetadataDeconflictSearchResultPanel extends Composite{

    private final VerticalContainer searchPanel;
    private final ScrollContainer scrollPanel;
    private final MECustomTableWidget table;
    private final TabContainer tabContainer;
    private final HorizontalContainer buttonContainer;

    private Long profileId = null;
    private Long selectedResultId = null;
    private final String requestKey;
    private String tabName;

    private final List<UiCacheResult> resultToDeconflictList = new ArrayList<UiCacheResult>();

    private final IMEManagerServiceAsync meManagerService = GWT.create(IMEManagerService.class);
    private final MEConstants constants = (MEConstants) GWT.create( MEConstants.class );

    private static final String STYLE_SCROLL_CONTAINER = "me-SearchResult-scrollContainer";
    private static final String STYLE_BUTTON_CONTAINER = "me-SearchResult-Profile-buttonPanel";
    /*Constructor*/
    public MetadataDeconflictSearchResultPanel(Long profileId, String requestKey, TabContainer tabContainer){
        this.scrollPanel = new ScrollContainer();
        this.searchPanel = new VerticalContainer();
        this.profileId = profileId;
        this.requestKey = requestKey;
        this.tabContainer = tabContainer;
        scrollPanel.setAlwaysShowScrollBars(true);
        scrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);


        searchPanel.add(scrollPanel);

        table = new MECustomTableWidget();
        addTableHeader();
        scrollPanel.add(table);

        buttonContainer = createButtonPanel();
        searchPanel.add(buttonContainer);
        searchPanel.setCellVerticalAlignment(buttonContainer, VerticalPanel.ALIGN_BOTTOM);

        this.initWidget(searchPanel);
    }

    public void searchResultToDeconflict(){
        refresh();
        getResultToDeconflict();
    }

    private  HorizontalContainer createButtonPanel() {
        HorizontalContainer container = new HorizontalContainer();
        String saveSelectionsText = constants.deConflictIgnoreButton();
        ButtonWidget ignoreButton = new ButtonWidget(saveSelectionsText);
        ignoreButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        ignoreButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                ignoreProfile();
                updateTabHeader();
            }
        });

        container.add(ignoreButton);

        container.addStyleName(STYLE_BUTTON_CONTAINER);

        return container;
    }

    /**
     * Create table header
     * */
    private void addTableHeader() {

        /*Add Radio Button Column*/
        table.addHeading("");

        /*Add Radio Button Column*/
        table.addHeading(constants.thirdPartyId());

        /*Add Radio Button Column*/
        table.addHeading(constants.thumbnail());

        /*Add Radio Button Column*/
        table.addHeading(constants.name());

        /*Add Radio Button Column*/
        table.addHeading(constants.year());

        /*Add Radio Button Column*/
        table.addHeading(constants.type());

        /*Add Radio Button Column*/
        table.addHeading(constants.actors());

        /*Add Radio Button Column*/
        table.addHeading(constants.ranking());
    }

    /**
     * Populate data in the table
     * */
    private void populateTable() {

        int row = table.addRow() + 1;

        for(final UiCacheResult result : resultToDeconflictList)
        {
            /*insert a blank row*/
            table.addRow(row);

            /*insert a radio button*/
            RadioButtonWidget radioButton = new RadioButtonWidget("options", "");

            if(result.getStatus().equalsIgnoreCase(UiCacheResultStatus.SELECTED.toString())) {
                radioButton.setValue(true);
            } else {
                radioButton.setValue(false);
            }

            radioButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    setSelectedResultId(result.getId());
                    updateSelection(UiCacheResultStatus.SELECTED.toString());
                    updateTabHeader();
                }
            });

            table.addCell(row, radioButton);

            /*insert a radio button*/
            LabelWidget remoteId = new LabelWidget(result.getRemoteId());
            table.addCell(row, remoteId);

            /*insert thumbnail*/
            ImageWidget thumbnail = new ImageWidget("cms_me_ui/jsps/thumbnail.jsp?url=" + result.getThumbnail(), 0, 0, 75,75);
            table.addCell(row, thumbnail);

            /*insert title name*/
            LabelWidget title = new LabelWidget(result.getTitle());
            table.addCell(row, title);

            /*insert year*/
            LabelWidget year = new LabelWidget(result.getYear());
            table.addCell(row, year);

            /*insert type*/
            LabelWidget type = new LabelWidget(result.getType());
            table.addCell(row, type);

            /*insert actors*/
            LabelWidget actors = new LabelWidget(result.getActors());
            table.addCell(row, actors);

            /*insert ranking*/
            LabelWidget ranking = new LabelWidget(result.getRanking()+"%");
            table.addCell(row, ranking);
        }
    }

    private void refresh(){
        table.removeAllRows();
    }

    /**
     * Method to get all the search result for the selected profile and request key.
     * 
     * */
    private void getResultToDeconflict(){
        resultToDeconflictList.clear();
        meManagerService.getConflictsToResolve(profileId, requestKey,  new AsyncCallback<List<UiCacheResult>>() {

            @Override
            public void onFailure(Throwable caught) {
                Window.alert(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(List<UiCacheResult> result) {
                if(result != null)
                {
                    resultToDeconflictList.addAll(result);
                    populateTable();
                }
            }
        });
    }

    private void updateSelection(String status){
        meManagerService.updateCacheResultStatus(requestKey, profileId, selectedResultId, status, new AsyncCallback<Void>() {

            @Override
            public void onFailure(Throwable caught) {
                Window.alert(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Void result) {
                searchResultToDeconflict();
            }

        });
    }

    /*As soon as a profile selection is made, this will mark the tab header text with '*' */
    private void updateTabHeader(){
        int index = 0;
        index = tabContainer.getTabBar().getSelectedTab();
        tabContainer.getTabBar().setTabText(index, "*"+getTabName());
    }

    /*This will mark "IGNORED" for all the records for the selected*/
    private void ignoreProfile(){
        updateSelection(UiCacheResultStatus.IGNORED.toString());
    }


    public Long getSelectedResultId(){
        return this.selectedResultId;
    }

    public void setSelectedResultId(Long selectedResultId){
        this.selectedResultId = selectedResultId;
    }


    /**
     * @return the tabName
     */
    public String getTabName() {
        return tabName;
    }

    /**
     * @param tabName the tabName to set
     */
    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    /**
     * Set the height (in pixels)
     * @param height
     */
    public void setHeight(int height){
        int scrollHeight = height - (buttonContainer.getOffsetHeight()+10);

        scrollPanel.setHeight(scrollHeight + "px");
    }
}
