package com.ericsson.cms.me.client.view.metadatadeconflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.ericsson.cms.me.client.i18n.MEComponentMessages;
import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.DeconflictMode;
import com.ericsson.cms.me.client.model.UiCacheResultStatus;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.model.UiTitle;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class MetadataDeconflictWidget  extends Composite   {
    private final MetadataDeconflictCallback meCallback;
    private UiTitle uiTitle;
    private final TabContainer tabContainer;
    private final RoundedDisclosureContainer originalMetadataDisclosurePanel;
    private final RoundedDisclosureContainer searchResultDisclosurePanel;
    private final HorizontalContainer buttonsPanel;
    private final List<UiSubscriptionProfile> profilesToDeconflictList = new ArrayList<UiSubscriptionProfile>();

    private final BusyIndicator busyIndicator = new BusyIndicator();
    private static final String STYLE_TABCONTAINER = "me-tabContainer";
    private static final String STYLE_RESULT_CONTAINER = "me-SearchResult-Container-background ";
    private static final String STYLE_BUTTON_PANEL = "me-SearchResult-Container-buttonPanel";
    private static final String STYLE_WIDGET = "me-Deconflict-Widget";

    private final DeconflictMode deconflictMode;
    private final String requestKey;

    private final IMEManagerServiceAsync meManagerService = GWT.create(IMEManagerService.class);
    private final MEConstants constants = (MEConstants) GWT.create( MEConstants.class );
    private final MEComponentMessages messages = (MEComponentMessages) GWT.create( MEComponentMessages.class );

    private final Collection<Widget> offsettingWidgets = new ArrayList<Widget>();

    public MetadataDeconflictWidget(String requestKey, MetadataDeconflictCallback meCallback, DeconflictMode deconflictMode) {

        this.meCallback = meCallback;
        this.requestKey = requestKey;
        this.deconflictMode = deconflictMode;
        uiTitle = new UiTitle();
        tabContainer = new TabContainer();
        tabContainer.addSelectionHandler( new SelectionHandler<Integer>() {
            @Override
            public void onSelection( SelectionEvent<Integer> event ) {
                MetadataDeconflictSearchResultPanel tab = (MetadataDeconflictSearchResultPanel)tabContainer.getWidget( event.getSelectedItem());
                tab.searchResultToDeconflict();
            }
        } );

        tabContainer.addStyleName(STYLE_TABCONTAINER);

        /* Create the main canvas */
        VerticalContainer frame = new VerticalContainer();
        frame.addStyleName(STYLE_RESULT_CONTAINER);

        /* Create the informational header message */
        VerticalContainer messageContainer = new VerticalContainer();
        messageContainer.add(getHeaderMessage());
        messageContainer.addStyleName(STYLE_WIDGET);
        frame.add(messageContainer);
        offsettingWidgets.add(messageContainer);

        /* Create the original metadata panel */
        originalMetadataDisclosurePanel = new RoundedDisclosureContainer("Original Metadata");
        originalMetadataDisclosurePanel.addStyleName(STYLE_WIDGET);
        frame.add(originalMetadataDisclosurePanel);
        offsettingWidgets.add(originalMetadataDisclosurePanel);

        /* Create the search results panel */
        searchResultDisclosurePanel = new RoundedDisclosureContainer("Enhancement Search Result");
        searchResultDisclosurePanel.addStyleName(STYLE_WIDGET);
        frame.add(searchResultDisclosurePanel);

        /* Create the buttons and button panel */
        buttonsPanel = createButtonPanel();
        frame.add(buttonsPanel);
        frame.setCellVerticalAlignment(buttonsPanel, VerticalPanel.ALIGN_BOTTOM);
        offsettingWidgets.add(buttonsPanel);
        getOriginalTitleMetadata();
        initSearchResultDisclosurePanel();

        updateSize();

        initWidget(frame);
    }

    private LabelWidget getHeaderMessage(){
        LabelWidget label = new LabelWidget(messages.metadataDeconflictHeaderMessage());

        return label;
    }

    private void initOriginalMetadataDisclosurePanel(){
        originalMetadataDisclosurePanel.setOpen(true);
        originalMetadataDisclosurePanel.setWidth("100%");

        FlexTableContainer table = new FlexTableContainer();
        table.setWidget(0, 0, new LabelWidget(uiTitle.getTitle()));
        table.setWidget(0, 1, new LabelWidget(uiTitle.getYear()));
        table.setWidget(0, 2, new LabelWidget(uiTitle.getType()));
        table.setWidget(0, 3, new LabelWidget(uiTitle.getActors()));
        table.setWidth("100%");

        originalMetadataDisclosurePanel.add(table);
    }

    private void initSearchResultDisclosurePanel(){
        searchResultDisclosurePanel.setOpen(true);
        searchResultDisclosurePanel.setWidth("100%");
        meManagerService.getProfilesToDeconflict(requestKey, new AsyncCallback<List<UiSubscriptionProfile>>() {

            @Override
            public void onFailure(Throwable caught) {
                busyIndicator.hide();
                showMessage(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(List<UiSubscriptionProfile> result) {

                if(result != null)
                {
                    profilesToDeconflictList.addAll(result);
                    MetadataDeconflictSearchResultPanel tab = null;
                    for(UiSubscriptionProfile profile: profilesToDeconflictList)
                    {
                        tab = new MetadataDeconflictSearchResultPanel(profile.getKey(), requestKey, tabContainer);
                        tab.setTabName(profile.getName());
                        tab.setHeight("100%");
                        tabContainer.add(tab, profile.getName() );
                    }

                    tabContainer.selectTab(0);
                    tabContainer.setHeight("100%");
                    searchResultDisclosurePanel.add(tabContainer);

                    updateSize();
                }
            }
        });
    }


    private void getOriginalTitleMetadata(){
        meManagerService.getOriginalTitle(requestKey, new AsyncCallback<UiTitle>() {

            @Override
            public void onFailure(Throwable caught) {
                busyIndicator.hide();
                showMessage(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(UiTitle result) {
                if(result != null)
                {
                    uiTitle = result;
                    initOriginalMetadataDisclosurePanel();
                }
            }
        });
    }

    private  HorizontalContainer createButtonPanel() {

        // Button panel
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName(STYLE_BUTTON_PANEL);

        /*When deconflict UI is called from Title UI*/
        if(DeconflictMode.SAVE == deconflictMode || deconflictMode == null)
        {
            buttonContainer.add(createSaveButton(constants.deConflictConfirmSelectionButton()));
            buttonContainer.add(createPreviewButton(constants.deConflictPreviewEnhancementButton()));
            buttonContainer.add(createSaveWithNoEnhancementButton(constants.deConflictDontEnahanceButton()));
            buttonContainer.add(createCancelSaveButton(constants.deConflictCancelSaveButton()));
        }
        /*When deconflict UI is called from Rules Preview UI*/
        else if(DeconflictMode.RULES_PREVIEW == deconflictMode)
        {
            buttonContainer.add(createSaveButton(constants.deConflictContinueButton()));
            buttonContainer.add(createCancelSaveButton(constants.deConflictCancelButton()));
        }
        /*When deconflict UI is called from template*/
        else if(DeconflictMode.TEMPLATE == deconflictMode)
        {
            buttonContainer.add(createSaveButton(constants.deConflictSaveSelectionButton()));
            buttonContainer.add(createPreviewButton(constants.deConflictPreviewEnhancementButton()));
            buttonContainer.add(createSaveWithNoEnhancementButton(constants.deConflictDontEnahanceButton()));
            buttonContainer.add(createCancelSaveButton(constants.deConflictCancelButton()));
        }

        return buttonContainer;
    }

    /* Confirm Selection Button */
    private ButtonWidget createSaveButton(String label){
        ButtonWidget saveButton = new ButtonWidget(label);
        saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
        saveButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                meCallback.clearMessage();
                validateAndSave();
            }
        });

        return saveButton;
    }

    /* Preview Enhancement Button */
    private ButtonWidget createPreviewButton(String label){
        ButtonWidget previewButton = new ButtonWidget(label);
        previewButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        previewButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                meCallback.clearMessage();
                validateAndPreview();
            }
        });

        return previewButton;
    }

    /* Don't Enhance Button */
    private ButtonWidget createSaveWithNoEnhancementButton(String label){
        ButtonWidget saveWithNoEnhancementButton = new ButtonWidget(label);
        saveWithNoEnhancementButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
        saveWithNoEnhancementButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                meCallback.clearMessage();
                ignoreEnhancementAndSave();
            }
        });

        return saveWithNoEnhancementButton;
    }

    /* Cancel Save Button */
    private ButtonWidget createCancelSaveButton(String label){
        ButtonWidget cancelSaveButton = new ButtonWidget(label);
        cancelSaveButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        cancelSaveButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                meCallback.clearMessage();
                meCallback.cancelSave();
            }
        });

        return cancelSaveButton;
    }

    /**
     * Validates if all the conflicting profiles have been
     * resolved before previewing this title.
     * */
    private void validateAndPreview(){
        meManagerService.requiresConflictResolution(requestKey,  new AsyncCallback<Boolean>(){

            @Override
            public void onFailure(Throwable caught) {
                showMessage(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Boolean requiresConflictResolved) {
                if(!requiresConflictResolved) {
                    meCallback.normalizeAndPreviewTitle();
                } else {
                    showMessage(messages.profilesNotResolveErrorMessage());
                }
            }

        });
    }

    /**
     * Validates if all the conflicting profiles have been
     * resolved before saving this title.
     * */
    private void validateAndSave(){
        meManagerService.requiresConflictResolution(requestKey,  new AsyncCallback<Boolean>(){

            @Override
            public void onFailure(Throwable caught) {
                showMessage(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Boolean conflictResolved) {
                if(!conflictResolved) {
                    meCallback.saveWithEnhancement();
                } else {
                    showMessage(messages.profilesNotResolveErrorMessage());
                }
            }

        });
    }

    /**
     * Ignores all profiles and continue title save
     * 
     * */
    private void ignoreEnhancementAndSave(){
        meManagerService.updateCacheResultStatus(requestKey, UiCacheResultStatus.IGNORED.toString(),  new AsyncCallback<Void>(){

            @Override
            public void onFailure(Throwable caught) {
                showMessage(caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Void result) {
                meCallback.saveWithoutEnhancement();
            }

        });
    }

    private void showMessage(String message){

        meCallback.showMessage(message, true);
    }

    public void updateSize()
    {
        Scheduler.get().scheduleDeferred(new ScheduledCommand()
        {
            @Override
            public void execute()
            {
                int height = Window.getClientHeight() - 280;

                for(Widget w : offsettingWidgets)
                {
                    height -= w.getOffsetHeight() + 4;
                }

                if(searchResultDisclosurePanel != null && searchResultDisclosurePanel != null){
                    height -= searchResultDisclosurePanel.getHeader().getOffsetHeight();
                }

                int widgetHeight = height - tabContainer.getTabBar().getOffsetHeight();
                for(int i=0; i<tabContainer.getDeckPanel().getWidgetCount(); i++){
                    MetadataDeconflictSearchResultPanel searchResultPanel = (MetadataDeconflictSearchResultPanel)tabContainer.getDeckPanel().getWidget(i);
                    searchResultPanel.setHeight(widgetHeight);
                }
            }
        });
    }

    private HandlerRegistration windowRegistration;
    @Override
    protected void onLoad()
    {
        super.onLoad();

        windowRegistration = Window.addResizeHandler(new ResizeHandler()
        {
            @Override
            public void onResize(ResizeEvent event)
            {
                updateSize();
            }
        });
    };

    @Override
    protected void onUnload()
    {
        if(windowRegistration != null){
            windowRegistration.removeHandler();
        }
        windowRegistration = null;

        super.onUnload();
    }
}
