package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelectorHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UndefinedFieldException;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class SampleFieldSelector extends SimpleContainer {

	private TextBox fieldTxtBox = new TextBox();
	private FieldSelector fieldSelector = FieldSelector.getTree(CriteriaType.BASIC_METADATA, UiCriteriaMode.EPISODE);
	private IFieldTreeObject selectedItem;

	public SampleFieldSelector(String assetType, String xpath) throws UndefinedFieldException {
		//put in styles for text box
		fieldTxtBox.setReadOnly(true);
		fieldTxtBox.setWidth("300px");
		fieldTxtBox.addStyleName("small-txt");
		fieldTxtBox.addStyleName("black-txt");
		fieldTxtBox.setVisibleLength(35);
		fieldTxtBox.addClickHandler(getClickHandler());

		//set the selected item if necessary
		if(assetType != null && xpath != null) {
			selectedItem = TreeCreator.findMdmObject(assetType, xpath);
			updateField();
		}
		setWidget(fieldTxtBox);
	}
	
	public SampleFieldSelector() throws UndefinedFieldException {
		fieldTxtBox.setReadOnly(true);
		fieldTxtBox.setWidth("300px");
		fieldTxtBox.addStyleName("small-txt");
		fieldTxtBox.addStyleName("black-txt");
		fieldTxtBox.setVisibleLength(35);
		fieldTxtBox.addClickHandler(getClickHandler());
		
		setWidget(fieldTxtBox);
	}
	
	public IFieldTreeObject getSelection() {
		return selectedItem;
	}
	
	public boolean hasSelection() {
		return selectedItem != null;
	}

	/*
	 * the click handler for the text box
	 */
	private ClickHandler getClickHandler() {
		return new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				//get the position of the box and show the widget
				int x = fieldTxtBox.getAbsoluteLeft();
				int y = fieldTxtBox.getAbsoluteTop();
				fieldSelector.show(x, y, selectedItem, getSelectHandler());
			}
		};
	}

	/*
	 * update the text box with the display name of the currently selected field
	 */
	private void updateField() {
		String str = selectedItem.getFullDisplayName();
		fieldTxtBox.setText(str);
		fieldTxtBox.setTitle(str);
	}

	/*
	 * the selection handler for the field selector
	 */
	public FieldSelectorHandler getSelectHandler() {
		return new FieldSelectorHandler() {

			@Override
			public void onSelection(TreeItem item) {
				selectedItem = (IFieldTreeObject) item.getUserObject();
				updateField();
			}

			@Override
			public boolean isSelectable(TreeItem item) {
				//only allows leaf nodes to be selected
				return !((IFieldTreeObject) item.getUserObject()).getDataType().equals(UIDataType.COMPLEX);
			}
		};
	}
}

