/**
 * 
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * @author AnujJain
 *
 */
public class SubscriptionProfileAnchorChangeListener implements AnchorChangeListener {
	private final SubscriptionProfileListPanel widget;
	private static String SUBSCRIPTION_PROFILE_ID = "id";
	private static String PARAMETER_DELIMITER = "&";
	private static String VALUE_DELIMITER = "=";
	
	 public SubscriptionProfileAnchorChangeListener( SubscriptionProfileListPanel listPanel ) {
	        this.widget = listPanel;
	 }
	 
	@Override
	public void anchorChanged(String anchor) {
		long subscriptionProfileId = 0L;

        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( SUBSCRIPTION_PROFILE_ID ) ) {
            widget.getSubscriptionProfileTable().reset();

            // skip the first char
            anchor = anchor.substring( 5 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( SUBSCRIPTION_PROFILE_ID ) ) {
                	subscriptionProfileId = Long.parseLong( paramValue[1] );
                }
            }
            
            IMEManagerServiceAsync service = GWT.create( IMEManagerService.class );
            service.getSubscriptionProfile(subscriptionProfileId, new NeptuneAsyncCallback<UiSubscriptionProfile>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                     Window.alert( caught.getLocalizedMessage() );
                }

                @Override
                public void onNeptuneSuccess(UiSubscriptionProfile result) {
                    widget.getSubscriptionProfileTable().showDetailView(new UiSubscriptionProfileRecord(result)); 
                }   
            
            } );
        } else {
            widget.clearMessages();
            widget.getSubscriptionProfileTable().setAnchor( anchor );
        }
		
	}
	
	

}
