/**
 * 
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.SubscriptionProfileSearchResult;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * @author AnujJain
 *
 */
public class SubscriptionProfileDataProvider implements DataProvider<Long, UiSubscriptionProfileRecord> {

	// columns for this table
    private final List<Column<?, UiSubscriptionProfileRecord>> columns;
    private final ColumnBase<String, UiSubscriptionProfileRecord> idColumn;
    private final ColumnBase<String, UiSubscriptionProfileRecord> nameColumn;
    private final ColumnBase<String, UiSubscriptionProfileRecord> pluginNameColumn;
    
    // column names
    private static String ID_COLUMN 			= "id";
    private static String NAME_COLUMN 			= "name";
    private static String PLUGIN_NAME_COLUMN 	= "pluginName";
    
    private IBusyNotifier busyNotifier;
    
    private MEConstants constants = (MEConstants) GWT.create( MEConstants.class );
    private IMEManagerServiceAsync subscriptionProfileService = GWT.create(IMEManagerService.class);
  
    public SubscriptionProfileDataProvider(SubscriptionProfileListPanel listsPanel){
    	columns = new ArrayList<Column<?, UiSubscriptionProfileRecord>>();
    	
    	/*Adding ID Column*/
    	idColumn = new ColumnBase<String, UiSubscriptionProfileRecord>( ID_COLUMN,constants.profileId() ) {
            public View<String> getView( UiSubscriptionProfileRecord record ) {
                return new LabelStringView( record.getSubscriptionProfile().getKey()+"");
            }
        };
        idColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( idColumn );
        
        /*Adding Name Column*/
    	nameColumn = new ColumnBase<String, UiSubscriptionProfileRecord>( NAME_COLUMN,constants.profileName() ) {
            public View<String> getView( UiSubscriptionProfileRecord record ) {
                return new LabelStringView( record.getSubscriptionProfile().getName() );
            }
        };
        nameColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( nameColumn );
        
        /*Adding Plugin Column*/
        pluginNameColumn = new ColumnBase<String, UiSubscriptionProfileRecord>( PLUGIN_NAME_COLUMN,constants.pluginName() ) {
            public View<String> getView( UiSubscriptionProfileRecord record ) {
                return new LabelStringView( record.getSubscriptionProfile().getPluginName() );
            }
        };
        pluginNameColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( pluginNameColumn );
        
    }
    
    @Override
	public List<Column<?, UiSubscriptionProfileRecord>> getColumns() {
		return columns;
	}
    
    @Override
	public void getRecord(Long key, final AsyncCallback<UiSubscriptionProfileRecord> callback) {
    	notifyBusyStart();
    	subscriptionProfileService.getSubscriptionProfile(key, new NeptuneAsyncCallback<UiSubscriptionProfile>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
				notifyBusyFinish();
			}

			@Override
			public void onNeptuneSuccess(UiSubscriptionProfile result) {
				UiSubscriptionProfileRecord record = new UiSubscriptionProfileRecord();
				record.setSubscriptionProfile(result);
				callback.onSuccess(record);
				notifyBusyFinish();
			}
    		
		});
	}
    
    @Override
	public void getRecords(final AsyncCallback<List<UiSubscriptionProfileRecord>> callback) {
    	notifyBusyStart();
    	subscriptionProfileService.getSubscriptionProfileList(new NeptuneAsyncCallback<SubscriptionProfileSearchResult>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
				notifyBusyFinish();
				
			}

			@Override
			public void onNeptuneSuccess(SubscriptionProfileSearchResult result) {
				List<UiSubscriptionProfileRecord> recordList = new ArrayList<UiSubscriptionProfileRecord>();
				for(UiSubscriptionProfile profile : result.getUiSubscriptionProfileList()){
					UiSubscriptionProfileRecord record = new UiSubscriptionProfileRecord(profile);
					recordList.add(record);
				}
				Collections.sort(recordList);
				callback.onSuccess(recordList);
				notifyBusyFinish();
			}
    		
    	});

			
	}
    
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess( null );
		
	}

	@Override
	public boolean isRecordCountEnabled() {
		return false;
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	 public static interface IBusyNotifier {
	        void startingToBeBusy();

	        void doneBeingBusy();
	    }

	    public void setBusyNotifier( IBusyNotifier busyNotifier ) {
	        this.busyNotifier = busyNotifier;
	    }

	    private void notifyBusyStart() {
	        if ( busyNotifier != null ) {
	            busyNotifier.startingToBeBusy();
	        }
	    }

	    private void notifyBusyFinish() {
	        if ( busyNotifier != null ) {
	            busyNotifier.doneBeingBusy();
	        }
	    }
}
