/**
 * 
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.me.client.Permissions;
import com.ericsson.cms.me.client.i18n.MEComponentMessages;
import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.util.UiLongKeySerializer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * @author AnujJain
 *
 */
public class SubscriptionProfileDetailFeature extends AbstractDetailFeature<Long, UiSubscriptionProfileRecord>{

    private final MEConstants constants = (MEConstants) GWT.create( MEConstants.class );
    private final MEComponentMessages messages = (MEComponentMessages) GWT.create( MEComponentMessages.class );
    private final IMEManagerServiceAsync meManagerService = GWT.create(IMEManagerService.class);

    private final SubscriptionProfileListPanel parentPanel;

    public SubscriptionProfileDetailFeature(SubscriptionProfileListPanel parentPanel) {
        super( new UiLongKeySerializer() );
        this.parentPanel = parentPanel;
    }

    @Override
    public DetailView<Long, UiSubscriptionProfileRecord> getView(UiSubscriptionProfileRecord record,
            DetailViewCallback<Long, UiSubscriptionProfileRecord> callback) {
        this.parentPanel.clearMessages();
        return new SubscriptionProfileDetailView(record, parentPanel.getErrorPanel(), parentPanel.getSuccessPanel(),
                callback);
    }

    @Override
    public boolean hasDetailLink(Column<?, UiSubscriptionProfileRecord> column) {
        return column.getDisplayName().equals(constants.profileId());
    }

    @Override
    public void getNew(AsyncCallback<UiSubscriptionProfileRecord> callback) {
        this.parentPanel.clearMessages();
        if ( callback != null ) {
            callback.onSuccess( new UiSubscriptionProfileRecord( new UiSubscriptionProfile()) );
        }

    }

    @Override
    public void save(UiSubscriptionProfileRecord record, AsyncCallback<Void> callback) {
        // TODO Auto-generated method stub

    }

    @Override
    public void delete(List<UiSubscriptionProfileRecord> records, final AsyncCallback<Void> callback) {
        if (records != null && !records.isEmpty()) {
            if (Window.confirm(messages.deleteSubscriptionProfileConfirmation())) {
                List<UiSubscriptionProfile> copyrightHolderList = new ArrayList<UiSubscriptionProfile>();
                for (UiSubscriptionProfileRecord record : records) {
                    copyrightHolderList.add(record.getSubscriptionProfile());
                }

                parentPanel.clearMessages();
                meManagerService.deleteSubscriptionProfiles(copyrightHolderList,
                        new NeptuneAsyncCallback<Boolean>() {

                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        parentPanel.getErrorPanel().showMessage( messages.deleteSubscriptionProfileError() );
                        if (caught instanceof ValidationException ) {
                            ValidationException ve = (ValidationException) caught;
                            parentPanel.getErrorPanel().addMessage("Following profile(s) are in use by rules:");
                            for ( String message : ve.getValidationMessages() ) {
                                parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    @Override
                    public void onNeptuneSuccess(Boolean result) {
                        parentPanel.getSuccessPanel().showMessage( messages.deleteSubscriptionProfileSucceeded() );
                        callback.onSuccess(null);
                    }

                });
            }
        } else {
            Window.alert(messages.noSubscriptionProfileSelected());
        }

    }

    @Override
    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized( Permissions.ME_CREATE);
    }

    @Override
    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized( Permissions.ME_DELETE);
    }

}
