/**
 * 
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.me.client.Permissions;
import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.i18n.MEUIConstants;
import com.ericsson.cms.me.client.model.UiEnhancedField;
import com.ericsson.cms.me.client.model.UiFieldDefinition;
import com.ericsson.cms.me.client.model.UiProfileParam;
import com.ericsson.cms.me.client.model.UiSearchFieldCriteria;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.custom.ErrorPanel;
import com.ericsson.cms.me.client.view.custom.ResizeableTable;
import com.ericsson.cms.me.client.view.custom.SuccessPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldProviderResults;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UndefinedFieldException;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author AnujJain
 *
 */
public class SubscriptionProfileDetailView extends Composite implements DetailView<Long, UiSubscriptionProfileRecord> {
    private final NeptuneSecurity security;
    private static final String STYLE_PROFILE_CONTAINER = "profile-Container-background";
    private static final String STYLE_PROFILE_INNER_CONTAINER = "profile-inner-panel";
    private static final String STYLE_NAME = "content-SubscriptionProfilePanel";
    private static final String STYLE_SCROLL_CONTAINER = "profile-scroll-container";
    private static final String STYLE_WRAPPER_PANEL = "profile-wrapper-container";
    private static final String TEXTBOX_LENGTH = "300px";
    private static final int MAX_NAME_LENGTH = 255;
    private static String PARAM_LABEL_LENGTH = "150px";
    private static final int PARAM_MINRANK_LOWERBOUND = 0;
    private static final int PARAM_MINRANK_UPPERBOUND = 100;
    private final UiSubscriptionProfileRecord record;
    private final DetailViewCallback<Long, UiSubscriptionProfileRecord> callback;  // NOSONAR
    private final MEConstants constants = (MEConstants) GWT.create( MEConstants.class );
    private final MEUIConstants uiConstants = (MEUIConstants) GWT.create(MEUIConstants.class);

    private static final String FORCE_CONFLICT_RESOLUTION = "ForceConflictResolution";
    private static final String API_KEY = "apiKey";
    private static final String MAX_RESULTS = "max.results";
    private static final String MIN_RANK = "min.rank";
    private static final String SECRET_KEY = "secretkey";
    private static final String URL = "url";

    private VerticalContainer outerContainer;
    ResizeableDockLayoutPanel mainContainer;
    private HorizontalContainer buttonsContainer;

    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final IMEManagerServiceAsync subscriptionProfileService = GWT.create(IMEManagerService.class);

    private final ScrollPanel scrollPanel = new ScrollPanel();
    private final Grid mainGridPanel = new Grid(4,1);
    private final FormContainer profileDetailPanel = new FormContainer(HorizontalContainer.ALIGN_LEFT);
    private final ListBox pluginNameBox = new ListBox();
    private final TextBox nameBox = new TextBox();

    private static final int DIS_PANEL_WIDTH = 725;

    private UiSubscriptionProfile profileRecord = new UiSubscriptionProfile();
    private ResizeableTable identifierCriteriaTable;
    private ResizeableTable enhancedFieldsTable;
    private FlexTableContainer paramContainer;

    private final Map<String, Long> criteriaIdMap = new HashMap<String, Long>();
    private final Map<String, Long> enhFieldIdMap = new HashMap<String, Long>();
    private final Map<String, Long> fieldDefIdMap = new HashMap<String, Long>();
    private final Map<String, String> uiPropertiesMap = new HashMap<String, String>();
    List<UiProfileParam> paramList = new ArrayList<UiProfileParam>();

    private ErrorPanel errorPanel = new ErrorPanel();
    private SuccessPanel successPanel = new SuccessPanel();
    private String pluginName = null;
    private List<UiEnhancedField> enhancedFieldsList = null;
    private final List<String> requiredFieldsListGlobal = new ArrayList<String>();

    public SubscriptionProfileDetailView(final UiSubscriptionProfileRecord record, ErrorPanel errorPanel, SuccessPanel successPanel, DetailViewCallback<Long, UiSubscriptionProfileRecord> callback){
        this(record, callback);
        this.errorPanel = errorPanel;
        this.successPanel = successPanel;
    }

    public SubscriptionProfileDetailView(final UiSubscriptionProfileRecord record, DetailViewCallback<Long, UiSubscriptionProfileRecord> callback){
        this.record = record;
        this.callback = callback;
        security = NeptuneApplication.getApplication().getSecurity();
        clearMessages();

        createBasicPanels();

        if (record.getKey() != null){
            this.pluginName = record.getSubscriptionProfile().getPluginName();

            getSubscriptionProfile();

            for(UiSearchFieldCriteria curCriteria : record.getSubscriptionProfile().getSearchCriteria()){
                criteriaIdMap.put(curCriteria.getValue(), curCriteria.getId());
                fieldDefIdMap.put(curCriteria.getField().getName(), curCriteria.getField().getId());
            }

            for(UiEnhancedField curField : record.getSubscriptionProfile().getEnhancedFields()){
                enhFieldIdMap.put(curField.getFieldDefinition().getName(), curField.getId());
                fieldDefIdMap.put(curField.getFieldDefinition().getName(), curField.getFieldDefinition().getId());
            }

            loadSpecification();
        }

        //loadUIPropertiesMap();
        buildProfileIdSection();
        buildProfileNameSection();
        buildPluginSection();
        buildButtonsSection();
        busyIndicator.hide();
    }

    private void createBasicPanels() {
        outerContainer = new VerticalContainer();
        mainContainer 	= new ResizeableDockLayoutPanel(Unit.PX);
        mainContainer.addStyleName(STYLE_NAME);
        buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing(5);
        scrollPanel.setStyleName(STYLE_SCROLL_CONTAINER);
        mainGridPanel.setStyleName(STYLE_PROFILE_CONTAINER);
        mainGridPanel.setWidth("700px");
        profileDetailPanel.setStyleName(STYLE_PROFILE_INNER_CONTAINER);

        Window.addResizeHandler(mainContainer);

        layout();
        initWidget(outerContainer);

    }

    private class ResizeableDockLayoutPanel extends DockLayoutPanel implements ResizeHandler{

        public ResizeableDockLayoutPanel(Unit unit) {
            super(unit);
        }

        @Override
        public void onResize(ResizeEvent event) {
            layout();
        }


    }

    public void layout()
    {
        long height = Window.getClientHeight()<400?400:Window.getClientHeight()-215;
        long width 	= Window.getClientWidth()<900?900:Window.getClientWidth()-50;
        //outerContainer.add(errorPanel);
        //outerContainer.add(successPanel);
        outerContainer.add(mainContainer);
        mainContainer.setSize(width+"px", height+"px");
        mainContainer.addSouth(buttonsContainer, 35);
        mainContainer.add(scrollPanel);
    }

    private void getSubscriptionProfile(){

        subscriptionProfileService.getSubscriptionProfile(record.getKey(), new NeptuneAsyncCallback<UiSubscriptionProfile>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess(UiSubscriptionProfile result) {

                UiSubscriptionProfileRecord uiProfileRecord = new UiSubscriptionProfileRecord();
                uiProfileRecord.setSubscriptionProfile(result);
                profileRecord = result;
            }
        });
    }

    /* Loading Specification for the SampleFieldSelector */
    private void loadSpecification() {
        if (TreeCreator.getSpec() != null) {
            buildCriteriaSection();
            if(security.isUserInRole(Permissions.ME_VIEW_PROFILE_PARAMETER)){
                loadUIPropertiesMap();
                //loadProfilePluginParameters();
            }
            return;
        }

        IMdmFieldProviderAsync specManagerService =  GWT.create(IMdmFieldProvider.class);
        specManagerService.getFields(TreeCreator.getSpecLastUpdateDate(), new NeptuneAsyncCallback<FieldProviderResults>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess(FieldProviderResults result) {
                busyIndicator.show();
                busyIndicator.center();
                // set spec and fire event to change tab contents
                if(result.requiresUpdate()) {
                    TreeCreator.setSpec(result);
                }
                buildCriteriaSection();
                if(security.isUserInRole(Permissions.ME_VIEW_PROFILE_PARAMETER)){
                    loadUIPropertiesMap();
                    //loadProfilePluginParameters();
                }
            }
        });
        busyIndicator.hide();
    }

    /* Adding Profile Id */
    private void buildProfileIdSection() {
        LabelWidget profileIdLabel = new LabelWidget(constants.profileId() + ":");
        LabelWidget profileIdValueLabel = new LabelWidget("");
        if (record.getKey() != null) {
            profileIdValueLabel = new LabelWidget(record.getSubscriptionProfile().getKey().toString());
            profileDetailPanel.addRow(profileIdLabel, profileIdValueLabel, false);
        }
    }

    /* Adding Profile Name */
    private void buildProfileNameSection() {
        LabelWidget profileNameLabel = new LabelWidget(constants.profileName() + ":");
        if (record.getKey() != null) {
            nameBox.setText(record.getSubscriptionProfile().getName());
            nameBox.setReadOnly(true);
        }
        nameBox.setWidth(TEXTBOX_LENGTH);
        nameBox.setMaxLength(MAX_NAME_LENGTH);
        profileDetailPanel.addRow(profileNameLabel, nameBox, true);
    }

    /* Adding Plugin Name */
    private void buildPluginSection(){
        subscriptionProfileService.getPluginsList(new NeptuneAsyncCallback<List<String>>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                Window.alert("Oops an error.." + caught.getLocalizedMessage());
            }

            @Override
            public void onNeptuneSuccess(List<String> result) {
                createPluginListView(result);
            }
        });
    }

    private void createPluginListView(List<String> pluginNames) {
        LabelWidget pluginLabel = new LabelWidget(constants.pluginName() + ":");
        int i=1;
        pluginNameBox.addItem(constants.select());
        for (String name : pluginNames)
        {
            pluginNameBox.addItem(name);
            if (name.equals(record.getSubscriptionProfile().getPluginName())) {
                pluginNameBox.setSelectedIndex(i);
            }
            i++;
        }
        pluginNameBox.setWidth(TEXTBOX_LENGTH);
        if (record.getKey() != null) {
            pluginNameBox.setEnabled(false);
        }
        pluginNameBox.addChangeHandler(new ChangeHandler(){
            @Override
            public void onChange(ChangeEvent event) {
                clearMessages();
                requiredFieldsListGlobal.clear();
                busyIndicator.show();
                busyIndicator.center();
                int index = pluginNameBox.getSelectedIndex();
                if(index == 0){
                    errorPanel.addMessage("Please select a Plugin Name");
                    busyIndicator.hide();
                    return;
                }
                pluginName = pluginNameBox.getItemText(index);
                if(!pluginName.trim().isEmpty()){
                    loadUIPropertiesMap();
                    //loadProfilePluginParameters();
                    loadSpecification();
                }
            }
        });

        profileDetailPanel.addRow(pluginLabel, pluginNameBox, true);
        mainGridPanel.setWidget(0, 0, profileDetailPanel);
    }

    /* Adding Selection Criteria */
    private void buildCriteriaSection() {
        subscriptionProfileService.getEnhancedFields(pluginName, new AsyncCallback<List<UiEnhancedField>>() {

            @Override
            public void onFailure(Throwable caught) {
                busyIndicator.hide();
                Window.alert("Error in getEnhancedFields.." + caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(List<UiEnhancedField> result) {
                enhancedFieldsList = result;
                Collections.sort(enhancedFieldsList);
                try {
                    createCriteriaView(result);
                    createEnhancementView();
                    busyIndicator.hide();
                } catch (UndefinedFieldException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createCriteriaView(List<UiEnhancedField> result) throws UndefinedFieldException {
        VerticalContainer criteriaWrapperPanel = new VerticalContainer();
        criteriaWrapperPanel.addStyleName(STYLE_WRAPPER_PANEL);
        ArrayList<List<Widget>> requiredValues = new ArrayList<List<Widget>>();
        RoundedDisclosureContainer identifierCriteriaDisPanel = new RoundedDisclosureContainer(constants.identifierCriteria());
        identifierCriteriaDisPanel.setOpen(true);
        identifierCriteriaDisPanel.setWidth(DIS_PANEL_WIDTH + "px");

        List<List<Widget>> existingValues;

        // Getting Required fields for plugin
        List<String> requiredFieldsList = new ArrayList<String>();
        for (UiEnhancedField field : result)
        {
            if(field.getFieldDefinition().isDisplay() && field.getFieldDefinition().isRequired())
            {
                requiredFieldsList.add(field.getFieldDefinition().getName());
            }
        }
        requiredFieldsListGlobal.addAll(requiredFieldsList);

        // criteria of existing profile
        if (record.getKey() != null)
        {
            Iterator itCriteria = record.getSubscriptionProfile().getSearchCriteria().iterator();
            List<UiSearchFieldCriteria> criteriaList = new ArrayList<UiSearchFieldCriteria>();
            while (itCriteria.hasNext()) {
                UiSearchFieldCriteria curSfc = (UiSearchFieldCriteria) itCriteria.next();
                if (curSfc.getField() != null && requiredFieldsListGlobal.contains(curSfc.getField().getName())) {
                    curSfc.getField().setRequired(true);
                }
                criteriaList.add(curSfc);
            }

            //Sort the lists
            Collections.sort(result);
            Collections.sort(criteriaList, new Comparator<UiSearchFieldCriteria>(){
                @Override
                public int compare(UiSearchFieldCriteria o1, UiSearchFieldCriteria o2){
                    int result = 0;

                    if(o2 != null && o1.getField() != null && o2.getField() != null){
                        if(o1.getField().isRequired() == o2.getField().isRequired()){
                            if(o1.getField().getName() != null){
                                result = o1.getField().getName().compareTo(o2.getField().getName());
                            }
                        } else{
                            result = o1.getField().isRequired() ? -1 : 1;
                        }
                    }

                    return result;
                }
            });

            existingValues = new ArrayList<List<Widget>>();
            // Adding required fields
            List<String> critNames = new ArrayList<String>();
            if (!requiredFieldsList.isEmpty()){
                for(String reqField : requiredFieldsList){
                    for(UiSearchFieldCriteria field : criteriaList){
                        critNames.add(field.getField().getName());
                    }
                    if(critNames.contains(reqField)){
                        //requiredFieldsList.remove(reqField);
                        continue;
                    }else{
                        List<Widget> row = new ArrayList<Widget>();
                        ListBox requiredFieldBox = new ListBox();
                        requiredFieldBox.setWidth(TEXTBOX_LENGTH);
                        requiredFieldBox.addItem(reqField);
                        requiredFieldBox.setEnabled(false);
                        row.add(requiredFieldBox);
                        SampleFieldSelector selector = new SampleFieldSelector();
                        try {
                            selector = new SampleFieldSelector();
                        } catch (UndefinedFieldException ufe) {
                        }
                        row.add(selector);
                        existingValues.add(row);
                        identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result), existingValues, false);
                    }
                }
            }
            for (UiSearchFieldCriteria criteria : criteriaList) {
                ListBox providerFieldBox = new ListBox();
                providerFieldBox.setWidth(TEXTBOX_LENGTH);
                int index = 0;
                boolean required = false;
                for (UiEnhancedField field : result)
                {
                    if(field.getFieldDefinition().isDisplay() && field.getFieldDefinition().isSearchable())
                    {
                        providerFieldBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
                        if (field.getFieldDefinition().getName().equals(criteria.getField().getName())) {
                            providerFieldBox.setSelectedIndex(index);
                        }
                        if (!requiredFieldsList.isEmpty() && requiredFieldsList.contains(criteria.getField().getName())) {
                            providerFieldBox.setEnabled(false);
                            providerFieldBox.setTitle(criteria.getField().getName() + " is required by the plugin");
                            required = true;
                        }
                        index++;
                    }
                }

                List<Widget> curRow = new ResizeableTable().new TableRow<Widget>(!required);
                curRow.add(providerFieldBox);
                SampleFieldSelector selector = new SampleFieldSelector();
                try {
                    selector = new SampleFieldSelector(criteria.getAssetType(), criteria.getValue());
                } catch (UndefinedFieldException ufe) {
                }

                curRow.add(selector);

                existingValues.add(curRow);
            }
            identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result), existingValues, true);
        }
        // New Profile creation
        else {
            if (!requiredFieldsList.isEmpty()){
                for(String reqField : requiredFieldsList){
                    List<Widget> row = new ResizeableTable().new TableRow<Widget>(false);
                    ListBox requiredFieldBox = new ListBox();
                    requiredFieldBox.setWidth(TEXTBOX_LENGTH);
                    requiredFieldBox.addItem(reqField);
                    requiredFieldBox.setEnabled(false);
                    row.add(requiredFieldBox);
                    SampleFieldSelector selector = new SampleFieldSelector();
                    try {
                        selector = new SampleFieldSelector(null, null);
                    } catch (UndefinedFieldException ufe) {
                    }
                    row.add(selector);
                    requiredValues.add(row);
                    identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result), requiredValues, true);
                }
            }
            else{
                identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result));
            }
        }

        //Build header row
        List<String> headerRow = new ArrayList<String>();
        headerRow.add(constants.providerField());
        headerRow.add(constants.cmsField());

        identifierCriteriaTable.setHeaders(headerRow);
        identifierCriteriaDisPanel.add(identifierCriteriaTable);
        criteriaWrapperPanel.add(identifierCriteriaDisPanel);
        mainGridPanel.setWidget(1, 0, criteriaWrapperPanel);
    }

    private void createEnhancementView() {
        VerticalContainer enhancedFieldsWrapperPanel = new VerticalContainer();
        enhancedFieldsWrapperPanel.addStyleName(STYLE_WRAPPER_PANEL);
        RoundedDisclosureContainer enhancementFieldsDisPanel = new RoundedDisclosureContainer(constants.enhancementFields());
        enhancementFieldsDisPanel.setOpen(true);
        enhancementFieldsDisPanel.setWidth(DIS_PANEL_WIDTH + "px");
        VerticalContainer vContainer = new VerticalContainer();
        LabelWidget providerFieldNameLabel = new LabelWidget(constants.providerFieldName());
        vContainer.add(providerFieldNameLabel);
        if (record.getKey() != null) {
            Iterator itEnhanceFields = record.getSubscriptionProfile().getEnhancedFields().iterator();
            List<UiEnhancedField> uiEnhancedFieldsList = new ArrayList<UiEnhancedField>();
            List<List<Widget>> existingValues = new ArrayList<List<Widget>>();
            while (itEnhanceFields.hasNext()) {
                uiEnhancedFieldsList.add((UiEnhancedField) itEnhanceFields.next());
            }
            //Sort the lists
            Collections.sort(enhancedFieldsList);
            Collections.sort(uiEnhancedFieldsList, new Comparator<UiEnhancedField>(){
                @Override
                public int compare(UiEnhancedField o1, UiEnhancedField o2){
                    int result = 0;

                    if(o2 != null && o1.getFieldDefinition() != null && o2.getFieldDefinition() != null){
                        if(o1.getFieldDefinition().isInUsedByRule() == o2.getFieldDefinition().isInUsedByRule()){
                            if(o1.getFieldDefinition().getName() != null){
                                result = o1.getFieldDefinition().getName().compareTo(o2.getFieldDefinition().getName());
                            }
                        } else{
                            result = o1.getFieldDefinition().isInUsedByRule() ? -1 : 1;
                        }
                    }

                    return result;
                }
            });
            for (UiEnhancedField enhField : uiEnhancedFieldsList) {
                ListBox providerFieldNameBox = new ListBox();
                providerFieldNameBox.setWidth(TEXTBOX_LENGTH);
                int enhIndex = 0;
                for (UiEnhancedField field : enhancedFieldsList)
                {
                    if(field.getFieldDefinition().isDisplay())
                    {
                        providerFieldNameBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
                        if (field.getFieldDefinition().getName().equals(enhField.getFieldDefinition().getName())) {
                            providerFieldNameBox.setSelectedIndex(enhIndex);
                        }
                        enhIndex++;
                    }
                }

                List<Widget> curRow = new ArrayList<Widget>();

                /*Grey out the enhance field if it is in use by a rule*/
                if(enhField.getFieldDefinition().isInUsedByRule())
                {
                    providerFieldNameBox.setEnabled(false);
                    StringBuilder tooltipText = new StringBuilder();
                    List<String> ruleNamesList = enhField.getFieldDefinition().getRulesUsingThisField();
                    if(ruleNamesList != null && ruleNamesList.size() > 0)
                    {
                        /*Creating a tool tip message to show all the rules that are using this field*/
                        tooltipText.append(constants.fieldsInUseByRuleMsg(enhField.getFieldDefinition().getName()));
                        for(String ruleName : ruleNamesList) {
                            tooltipText.append("- " + ruleName + " \n");
                        }
                    }

                    providerFieldNameBox.setTitle(tooltipText.toString());
                    curRow = new ResizeableTable().new TableRow<Widget>(false);
                }

                curRow.add(providerFieldNameBox);
                existingValues.add(curRow);
            }
            enhancedFieldsTable = new ResizeableTable(new EnhancedFieldRowGen(enhancedFieldsList), existingValues, true);
        }else{
            enhancedFieldsTable = new ResizeableTable(new EnhancedFieldRowGen(enhancedFieldsList));
        }

        //Build header row
        List<String> headerRow = new ArrayList<String>();
        headerRow.add(constants.providerField());

        enhancedFieldsTable.setHeaders(headerRow);
        enhancementFieldsDisPanel.add(enhancedFieldsTable);
        enhancedFieldsWrapperPanel.add(enhancementFieldsDisPanel);
        mainGridPanel.setWidget(2, 0, enhancedFieldsWrapperPanel);
    }

    /* Adding Profile Parameters */
    private void buildProfileParametersSection() {
        VerticalContainer profileParametersWrapperPanel = new VerticalContainer();
        profileParametersWrapperPanel.addStyleName(STYLE_WRAPPER_PANEL);
        RoundedDisclosureContainer profileParametersDisPanel = new RoundedDisclosureContainer(constants.profileParameters());
        profileParametersDisPanel.setOpen(true);
        profileParametersDisPanel.setWidth(DIS_PANEL_WIDTH + "px");
        //profileParametersDisPanel.setWidth(PROFILE_NAME_MAX_LENGTH);
        paramContainer = new FlexTableContainer();

        //Sort the parameters by name
        //List<UiProfileParam> paramList = new ArrayList<UiProfileParam>();
        if(record.getKey() != null){
            paramList.clear();
            paramList.addAll(record.getSubscriptionProfile().getParams());
        }


        Collections.sort(paramList);

        Iterator<UiProfileParam> iter = paramList.iterator();
        int i=0;
        while(iter.hasNext())
        {
            UiProfileParam uiParam = iter.next();
            LabelWidget paramLabel = null;

            String displayName = uiPropertiesMap.get(uiParam.getName());

            if(displayName != null && !displayName.isEmpty()) {
                paramLabel = new LabelWidget(displayName);
            } else {
                paramLabel = new LabelWidget(uiParam.getName());
            }

            paramLabel.setWidth(PARAM_LABEL_LENGTH);

            Hidden parameterKey = new Hidden();
            parameterKey.setValue(uiParam.getName());

            Hidden paramId = new Hidden();
            paramId.setValue(String.valueOf(uiParam.getId()));

            Widget parameterWidget = null;
            if (constants.forceConflictResolution().equals(uiParam.getName()))
            {
                CheckBoxWidget checkBox = new CheckBoxWidget();
                parameterWidget = checkBox;
                checkBox.setValue(Boolean.valueOf(uiParam.getValue()));
            }
            else
            {

                TextBoxWidget parameterFieldBox = new TextBoxWidget();
                parameterWidget = parameterFieldBox;
                parameterFieldBox.setWidth(TEXTBOX_LENGTH);

                if (uiParam.getValue() != null) {
                    parameterFieldBox.setText(uiParam.getValue().toString());
                }
            }

            paramContainer.setWidget(i, 0, paramLabel);
            paramContainer.setWidget(i, 1, parameterWidget);
            paramContainer.setWidget(i, 2, paramId);
            paramContainer.setWidget(i, 3, parameterKey);

            i++;
        }
        profileParametersDisPanel.add(paramContainer);
        profileParametersWrapperPanel.add(profileParametersDisPanel);
        mainGridPanel.setWidget(3, 0, profileParametersWrapperPanel);
    }

    private void getLatestProfileFromUi() throws ValidationException{

        if(record.getSubscriptionProfile().getKey()!=null){
            profileRecord.setKey(record.getSubscriptionProfile().getKey());
        }

        profileRecord.setName(nameBox.getText());
        profileRecord.setPluginName(pluginNameBox.getValue(pluginNameBox.getSelectedIndex()));
        profileRecord.setSearchCriteria(getCriteriaSet());
        profileRecord.setEnhancedFields(getEnhancedFieldSet());
        profileRecord.setParams(getParams());
    }

    private Set<UiSearchFieldCriteria> getCriteriaSet() throws ValidationException{
        Set<UiSearchFieldCriteria> criteriaSet = new HashSet<UiSearchFieldCriteria>();

        if(identifierCriteriaTable != null){
            for(List<Widget> curRow : identifierCriteriaTable.getValues()){
                UiSearchFieldCriteria curCriteria = new UiSearchFieldCriteria();

                ListBox fieldDefBox = (ListBox)curRow.get(0);
                UiFieldDefinition fieldDef = new UiFieldDefinition();

                fieldDef.setName(fieldDefBox.getItemText(fieldDefBox.getSelectedIndex()));

                Long id = fieldDefIdMap.get(fieldDef.getName());
                if(id != null){
                    fieldDef.setId(fieldDefIdMap.get(fieldDef.getName()));
                }

                fieldDef.setPath(fieldDefBox.getValue(fieldDefBox.getSelectedIndex()));

                curCriteria.setField(fieldDef);

                SampleFieldSelector sfs = (SampleFieldSelector)curRow.get(1);

                if(sfs.getSelection() != null && sfs.getSelection().getField() != null){
                    curCriteria.setAssetType(sfs.getSelection().getAssetType());
                    curCriteria.setValue(sfs.getSelection().getField());
                } else{
                    List<String> validationErrors = new ArrayList<String>();
                    validationErrors.add(constants.emptyFieldMessage());
                    throw new ValidationException(validationErrors);
                }


                curCriteria.setId(criteriaIdMap.get(curCriteria.getValue()));

                criteriaSet.add(curCriteria);
            }
        }

        return criteriaSet;
    }

    private Set<UiEnhancedField> getEnhancedFieldSet(){
        Set<UiEnhancedField> enhancedFieldSet = new HashSet<UiEnhancedField>();

        if(enhancedFieldsTable != null){
            for(List<Widget> curRow : enhancedFieldsTable.getValues()){
                UiEnhancedField curEnhancedField = new UiEnhancedField();

                ListBox fieldBox = (ListBox)curRow.get(0);
                UiFieldDefinition fieldDef = new UiFieldDefinition();

                fieldDef.setName(fieldBox.getItemText(fieldBox.getSelectedIndex()));

                //				Long id = fieldDefIdMap.get(fieldDef.getName());

                //				if(id != null){
                //					fieldDef.setId(fieldDefIdMap.get(fieldDef.getName()));
                //				}

                fieldDef.setPath(fieldBox.getValue(fieldBox.getSelectedIndex()));
                curEnhancedField.setFieldDefinition(fieldDef);
                curEnhancedField.setId(enhFieldIdMap.get(fieldDef.getName()));

                enhancedFieldSet.add(curEnhancedField);
            }
        }

        return enhancedFieldSet;
    }

    private Set<UiProfileParam> getParams(){
        Set<UiProfileParam> paramMap= new HashSet<UiProfileParam>();

        if(paramContainer != null)
        {
            for(int i=0; i<paramContainer.getRowCount(); i++)
            {
                //LabelWidget labelWidget = (LabelWidget)paramContainer.getWidget(i, 0);
                String value = null;

                Widget widget = paramContainer.getWidget(i, 1);

                if (widget instanceof CheckBoxWidget)
                {
                    value = ((CheckBoxWidget) widget).getValue() + "";
                }
                else if (widget instanceof TextBoxWidget)
                {
                    value = ((TextBoxWidget) widget).getValue() + "";
                }

                Hidden id = (Hidden)paramContainer.getWidget(i, 2);

                UiProfileParam param = new UiProfileParam();
                if(id != null){
                    String idStr = id.getValue();
                    if(idStr != null && !"null".equals(idStr)){
                        param.setId(Long.valueOf(idStr));
                    }
                }

                Hidden parameterKey = (Hidden)paramContainer.getWidget(i, 3);
                /*getting the key from the hidden*/
                param.setName(parameterKey.getValue());
                param.setValue(value);

                paramMap.add(param);
            }
        }

        return paramMap;
    }

    private void buildButtonsSection() {

        /* Adding Buttons */
        FlowPanel ButtonPanel = new FlowPanel();
        // Save Button
        Button saveButton = new Button(constants.saveButton());
        saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
        saveButton.addClickHandler(new ClickHandler(){
            @Override
            public void onClick(ClickEvent event){

                //				if(!Window.confirm(constants.saveProfileConfirmMessage())){
                //					return;
                //				}
                clearMessages();
                try{
                    getLatestProfileFromUi();

                    List<String> errors = validateUiProfile(profileRecord);
                    if(errors.size() <= 0){

                        subscriptionProfileService.saveSubscriptionProfile(profileRecord, new NeptuneAsyncCallback<UiSubscriptionProfile>() {

                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                                handleSaveException(caught);
                            }

                            @Override
                            public void onNeptuneSuccess(UiSubscriptionProfile result) {
                                // Disable profile name and plugin name box just after saving a new profile
                                nameBox.setEnabled(false);
                                pluginNameBox.setEnabled(false);
                                //Window.alert(profileRecord.getName() + " saved successfully");
                                successPanel.showMessage(constants.saveProfileSuccessMessage(profileRecord.getName()));

                                record.setSubscriptionProfile(result);
                                record.setKey(result.getKey());

                                loadSpecification();
                            }
                        } );
                    } else{
                        errorPanel.showErrorHeader("Error saving profile");
                        errorPanel.addErrors(errors);

                    }
                    //layout();
                } catch(ValidationException ve){
                    handleSaveException(ve);
                }
            }

        });

        //		if((security.isUserInRole(Permissions.ME_VIEW)) && ((security.isUserInRole(Permissions.ME_MODIFY)) || (security.isUserInRole(Permissions.ME_CREATE)))) {
        //			ButtonPanel.add(saveButton);
        //		}

        if(record.getKey() == null && security.isUserInRole(Permissions.ME_CREATE) || security.isUserInRole(Permissions.ME_MODIFY)) {
            ButtonPanel.add(saveButton);
        }

        // Delete Button
        /*		Button deleteButton = new Button(constants.deleteButton());
		deleteButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		deleteButton.addClickHandler(new ClickHandler(){
			public void onClick(ClickEvent event){

				if(!Window.confirm(constants.deleteProfileConfirmMessage(record.getSubscriptionProfile().getName()))){
					return;
				}

				//Hide any previous validation messages
				//clearMessages();
			}
		});
		if((security.isUserInRole(Permissions.ME_VIEW)) && (security.isUserInRole(Permissions.ME_DELETE))) {
			ButtonPanel.add(deleteButton);
		}
         */
        // Cancel Button
        Button cancelButton = new Button(constants.cancelButton());
        cancelButton.addStyleDependentName(StyleNames.CAUTION_BUTTON_STYLE);
        cancelButton.addClickHandler(new ClickHandler(){
            @Override
            public void onClick(ClickEvent event){

                //				if(!Window.confirm(constants.cancelProfileConfirmMessage())){
                //					return;
                //				}
                //Create anchor to navigate
                String token = "Content.Enhancement.SubscriptionProfile";
                History.newItem(token);
            }
        });

        ButtonPanel.add(cancelButton);
        buttonsContainer.add(ButtonPanel);
        /* Adding Data and Buttons Panels to mainContainer */
        scrollPanel.add(mainGridPanel);
    }

    private List<String> validateUiProfile(UiSubscriptionProfile profileRecord) {
        List<String> errors = new ArrayList<String>();
        String profileName = profileRecord.getName();
        if(profileName == null || profileName.trim().length() < 1){
            errors.add("Profile Name is a required field");
            //errorPanel.addMessage("Profile Name is a required field");
        }

        //		if(profileName.length() > MAX_NAME_LENGTH){
        //			valid=false;
        //			errorPanel.addMessage("Profile Name exceeds maximum length of " + 255);
        //		}

        //Validate the plugin name
        String name = profileRecord.getPluginName();
        if (name.equals(constants.select())) {
            errors.add("Plugin Name is a required field");
            //errorPanel.addMessage("Plugin Name is a required field");
        }

        //Validate Search Field Mapping fields
        Set<UiSearchFieldCriteria> crit = profileRecord.getSearchCriteria();
        List<String> fieldNames = new ArrayList<String>();
        for (UiSearchFieldCriteria field : crit){
            fieldNames.add(field.getField().getName());
        }
        for(String reqField : requiredFieldsListGlobal){
            if(!fieldNames.contains(reqField)){
                errors.add("Field '" + reqField +  "' is required in Search Field Mapping section");
            }
        }

        //Validate the profile params
        Set<UiProfileParam> params = profileRecord.getParams();
        Iterator<UiProfileParam> iter = params.iterator();
        while(iter.hasNext()){
            UiProfileParam uiParam = iter.next();
            if(uiParam.getName().equals(constants.paramPage())
                    || uiParam.getName().equals(constants.paramPageLimit())
                    || uiParam.getName().equals(constants.minRank())
                    || uiParam.getName().equals(constants.maxResults())){
                try{
                    if (!uiParam.getValue().isEmpty()) {
                        Integer.parseInt(uiParam.getValue());
                    }
                }
                catch(NumberFormatException nfe){
                    String paramName = uiPropertiesMap.get(uiParam.getName());
                    if(paramName == null || paramName.isEmpty()) {
                        paramName = uiParam.getName();
                    }

                    errors.add("Parameter '" + paramName +  "' should be an integer");
                }
            }

            if (uiParam.getName().equals(constants.minRank()) && !uiParam.getValue().isEmpty()) {
                int intParam = Integer.parseInt(uiParam.getValue());
                if (intParam < PARAM_MINRANK_LOWERBOUND || intParam > PARAM_MINRANK_UPPERBOUND) {
                    String paramName = uiPropertiesMap.get(uiParam.getName());
                    if (paramName == null || paramName.isEmpty()) {
                        paramName = uiParam.getName();
                    }
                    errors.add("Parameter '" + paramName + "' may not be less than " + PARAM_MINRANK_LOWERBOUND
                            + " or greater than " + PARAM_MINRANK_UPPERBOUND);
                }
            }
        }

        return errors;
    }

    private void handleSaveException(Throwable t){
        errorPanel.showMessage("Error saving " + profileRecord.getName());

        if(t instanceof ValidationException){
            ValidationException ve = (ValidationException) t;
            errorPanel.addErrors(ve.getValidationMessages());
        } else{
            errorPanel.addMessage(t.getMessage());
        }

    }

    private void clearMessages(){
        errorPanel.reset();
        successPanel.reset();
    }

    @Override
    public void release() {
        // TODO Auto-generated method stub

    }

    @Override
    public void revert() {
        // TODO Auto-generated method stub

    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

    @Override
    public UiSubscriptionProfileRecord getRecord() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void saveFailed(Throwable throwable) {
        // TODO Auto-generated method stub

    }

    @Override
    public Widget getWidget() {
        // TODO Auto-generated method stub
        return this;
    }

    @Override
    public String getStyleName() {
        // TODO Auto-generated method stub
        return null;
    }

    class IdentifierCriteriaRowGen implements ResizeableTable.TemplateRowGenerator{

        List<UiEnhancedField> result;

        public IdentifierCriteriaRowGen(List<UiEnhancedField> result){
            this.result = result;
        }

        @Override
        public List<Widget> getTemplateRow(){
            List<Widget> templateRow = new ArrayList<Widget>();

            ListBox providerFieldNameBox = new ListBox();
            providerFieldNameBox.setWidth(TEXTBOX_LENGTH);

            for(UiEnhancedField field : result){
                if(field.getFieldDefinition().isSearchable()) {
                    providerFieldNameBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
                }
            }

            templateRow.add(providerFieldNameBox);
            try{
                templateRow.add(new SampleFieldSelector());
            } catch(Exception e){}

            return templateRow;
        }
    }

    class EnhancedFieldRowGen implements ResizeableTable.TemplateRowGenerator{

        private final List<UiEnhancedField> result;

        public EnhancedFieldRowGen(List<UiEnhancedField> result){
            this.result = result;
        }

        @Override
        public List<Widget> getTemplateRow(){
            List<Widget> templateRow = new ArrayList<Widget>();

            ListBox providerFieldNameBox = new ListBox();
            providerFieldNameBox.setWidth(TEXTBOX_LENGTH);

            for(UiEnhancedField field : result){
                if(field.getFieldDefinition().isDisplay()) {
                    providerFieldNameBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
                }
            }

            templateRow.add(providerFieldNameBox);

            return templateRow;
        }
    }

    private void loadProfilePluginParameters(){
        subscriptionProfileService.getProfilePluginParams(pluginName, new AsyncCallback<Set<String>>() {

            @Override
            public void onFailure(Throwable caught) {
                busyIndicator.hide();
                Window.alert("Error in getProfilePluginParams.." + caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Set<String> result) {
                //createEnhancementView(result);
                paramList.clear();
                for(String param : result)
                {
                    UiProfileParam uiParam = new UiProfileParam();
                    uiParam.setName(param);
                    paramList.add(uiParam);
                }
                buildProfileParametersSection();
            }
        });
    }

    /*
     * Populated the map with key-value from the MEUIConstants.properties
     * 
     * */
    private void loadUIPropertiesMap(){

        uiPropertiesMap.put(FORCE_CONFLICT_RESOLUTION, uiConstants.ForceConflictResolution());
        uiPropertiesMap.put(API_KEY, uiConstants.apiKey());
        uiPropertiesMap.put(MAX_RESULTS, uiConstants.maxresults());
        uiPropertiesMap.put(MIN_RANK, uiConstants.minrank());
        uiPropertiesMap.put(SECRET_KEY, uiConstants.secretkey());
        uiPropertiesMap.put(URL, uiConstants.url());

        loadProfilePluginParameters();
    }
}
