/**
 * 
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.view.custom.ErrorPanel;
import com.ericsson.cms.me.client.view.custom.SuccessPanel;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileDataProvider.IBusyNotifier;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author AnujJain
 *
 */
public class SubscriptionProfileListPanel extends Composite{
	
	private SubscriptionProfileDataProvider dataProvider;
	private BookmarkFeature bookmarkFeature;
	private AnchorChangeListener anchorChangeListener;

	private VerticalContainer mainContainer;
	private TabContainer tabContainer = new TabContainer();
	private Table<Long, UiSubscriptionProfileRecord> table;
	private SubscriptionProfileDetailFeature detailFeature;
	private BusyIndicator busyIndicator = new BusyIndicator();
	
	private HeaderPanel header;
	private final ErrorPanel errorPanel = new ErrorPanel();
	private final SuccessPanel successPanel = new SuccessPanel();
    
	private MEConstants constants = (MEConstants) GWT.create( MEConstants.class );
    
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-SubscriptionProfilePanel";
    private static final String TAB_CONTAINER_STYLE = "me-tabContainer";
    
    public SubscriptionProfileListPanel() {
        this.dataProvider = new SubscriptionProfileDataProvider( this );
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
 
        init();
    }
    
    private void init() {
        initWidgets();
        setContainers();
    }
    
    private void setContainers() {
        mainContainer.add( header );
        mainContainer.add( successPanel );
        mainContainer.add( errorPanel );
        mainContainer.add(tabContainer);
    }
    
    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing( SPACING );
        mainContainer.setStylePrimaryName( STYLE_NAME );
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        
        VerticalContainer tabPanel = new VerticalContainer();
		tabContainer.add(tabPanel, constants.subscriptionProfileTabHeader());
		tabContainer.selectTab(0);
		
        this.initWidget( mainContainer );

        header = new HeaderPanel( "" );
       
        table = new Table<Long, UiSubscriptionProfileRecord>( dataProvider );
        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiSubscriptionProfileRecord>() {
            @Override
            public void onShowDetailView( TableDetailViewEvent<Long, UiSubscriptionProfileRecord> event ) {
                if ( event.isCreateView() ) {
                    header.setLabel(constants.subscriptionProfileListViewHeader() + " : " + constants.newProfileHeading());
                } else {
                    header.setLabel( constants.subscriptionProfileListViewHeader() + " : " + event.getRecord().getSubscriptionProfile().getName() );
                }
            }

            @Override
            public void onShowListView( TableViewEvent event ) {
                header.setLabel( constants.subscriptionProfileListViewHeader());
            }
        } );

        // bookmark feature
        bookmarkFeature = new BookmarkFeatureImpl();

        // detail feature
        detailFeature = new SubscriptionProfileDetailFeature( this );

        table.addDetailFeature( detailFeature );
        table.addBookmarkFeature(bookmarkFeature);

        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            	Window.alert(caught.getMessage());
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
            	table.refresh();
            }
        } );

        tabPanel.add(table);
        anchorChangeListener = new SubscriptionProfileAnchorChangeListener( this );
    }
    
    public Table<Long, UiSubscriptionProfileRecord> getSubscriptionProfileTable() {
        return this.table;
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {
        table.setAnchorChangeNotifier( reverseAnchorChangeListener );
    }

	public void clearMessages() {
		this.successPanel.reset();
		this.errorPanel.reset();
	}
	
	public ErrorPanel getErrorPanel() {
		return errorPanel;
	}

	public SuccessPanel getSuccessPanel() {
		return successPanel;
	}
}
