package com.tandbergtv.cms.portal.reports.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.reports.client.tab.report.ReportListTab;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class ReportsComponent extends ComponentBase {
	/** The Content Component Name */
	public static final String COMPONENT_NAME = "Reports";

	/* The values for the user properties loaded during initialization */
	private final ReportComponentConstants constants;

	/**
	 * Constructor
	 */
	public ReportsComponent() {
		constants = GWT.create(ReportComponentConstants.class);
	}

	// ========================================================================
	// ===================== COMPONENT METHODS
	// ========================================================================

	@Override
	public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink,
	        ServiceLoader serviceLoader, Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
	}

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {
		List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();

		return portletFactories;
	}

	@Override
	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		return null;
	}

	// ========================================================================
	// ===================== CONTENT - MENU ITEMS
	// ========================================================================

	@Override
	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
	    
	    /* Always all the group menu item */
		List<MenuItemBase> submenuItems = new ArrayList<MenuItemBase>();
        GroupMenuItem menuItem = new GroupMenuItem("Reporting",constants.menuGroupName(), submenuItems);
        tabs.add(menuItem);

        // if have appropriate permissions then add tab items to menu
        if (security.isUserInRole("Reports_View")) {
            /* Build the menu group: 'Content' */
            String menuName = constants.menuItemContent();
            
            ReportListTab reportListTab = new ReportListTab(eventSink, eventListenerRegistry);
            
            final WidgetMenuItem panel = 
                new WidgetMenuItem(menuName, 
                                    new SingletonWidgetFactory(reportListTab));

            submenuItems.add(panel);
        }

		return tabs;
	}

        @Override
        public String getName() {
            return "REPORTS";
        }
    
        @Override
        public String getDisplayName() {
            return constants.componentDisplayName();
        }
}
