package com.tandbergtv.cms.portal.reports.client.tab.report;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable.Cell;
import com.tandbergtv.cms.portal.reports.client.ReportComponentConstants;
import com.tandbergtv.cms.portal.reports.client.config.IUIReportConfigViewService;
import com.tandbergtv.cms.portal.reports.client.config.IUIReportConfigViewServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HiddenWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ReportListTab extends VerticalContainer {
	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
	
	private ReportComponentConstants constants = GWT.create(ReportComponentConstants.class);
	
	private FlexTable reportsTable;
	
	private IUIReportConfigViewServiceAsync service = GWT.create(IUIReportConfigViewService.class);
	
	private static final int REPORT_TITLE_COLUMN = 0;
	private static final int REPORT_ID_COLUMN = 1;
	
	public ReportListTab(EventSink eventSink, EventListenerRegistry eventListenerRegistry) {
		setStyleName(CONTAINER_PANEL_STYLE_LIST);
		setSpacing(5);
		
		final HeaderPanel header = new HeaderPanel(constants.menuItemContent());
		/*
		 * hack to not show the header when the table is loading
		 * consequence:
		 *  set the header visible again and again during list-detail view change,
		 *  when it is actually visible 
		 */
		header.setVisible(false);
		add(header);
		
		reportsTable = new FlexTable();
		
        reportsTable.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                Cell cell = reportsTable.getCellForEvent(event);

                HiddenWidget hiddenWidget = (HiddenWidget) reportsTable.getWidget(cell.getRowIndex(), REPORT_ID_COLUMN);
                if (hiddenWidget.getValue() != null && !"".equals(hiddenWidget.getValue())) {
                    long reportId = Long.parseLong(hiddenWidget.getValue()); 
                    
                    service.getReportLink(reportId, new NeptuneAsyncCallback<String>() {
                        
                        @Override
                        public void onNeptuneFailure(Throwable caught) {
                            header.setLabel("Something weird happened...");
                            header.setVisible(true);
                        }
    
                        @Override
                        public void onNeptuneSuccess(String reportLink) {
                            Window.open(reportLink, "Report", "");
                        }
                    });
                }
            }
        });
		
		service.getReportCategories(new NeptuneAsyncCallback<List<ReportCategory>>() {
        
            @Override
            public void onNeptuneFailure(Throwable caught) {
                header.setLabel("An error ocurred while retrieving the reports...");
                header.setVisible(true);
            }

            @Override
            public void onNeptuneSuccess(List<ReportCategory> categories) {
                int i = 0;
                for (ReportCategory category : categories) {
                    reportsTable.setText(i, 0, category.getName());
                    reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_HEADER_ROW);
                    reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT);
                    reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_DATACELL);
                    reportsTable.setWidget(i, REPORT_ID_COLUMN, new HiddenWidget("reportId"));
                    i++;
                    for (Report report : category.getReports()) {
                        reportsTable.setText(i, REPORT_TITLE_COLUMN, report.getTitle());
                        
                        HiddenWidget hiddenWidget = new HiddenWidget("reportId", report.getId().toString());
                        reportsTable.setWidget(i, REPORT_ID_COLUMN, hiddenWidget);
                        
                        reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_DATA_EVEN_ROW);
                        reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_DATACELL);
                        reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_DATACELL_TEXT);
                        reportsTable.getCellFormatter().addStyleName(i, REPORT_TITLE_COLUMN, TableConstants.STYLE_DATA_LINK);
                        
                        i++;
                    }
                    
                }
                header.setVisible(true);
                add(reportsTable);
            }
		});
		
	}

    public FlexTable getReportsTable() {
        return reportsTable;
    }

    public void setReportsTable(FlexTable reportsTable) {
        this.reportsTable = reportsTable;
    }

	
}
