package com.tandbergtv.cms.rules.ui.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanelFactory;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleSetDoesntExist;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RulesTab implements WidgetFactory {

	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);

	// All of the rules tabes share the same panel. BOOM BABY
	private Packages pkg;
	private SimpleContainer panel = new SimpleContainer();
	private BusyIndicator busyIndicator = new BusyIndicator();

	private UiRulesServiceAsync rulesService = GWT.create(UiRulesService.class);

	/**
	 * Constructor that takes in a package linked to this tab
	 * 
	 * @param pkg
	 */
	public RulesTab(Packages pkg) {
		this.pkg = pkg;
		/* Set the root widget style name */
		panel.setStylePrimaryName("rules-RulesTab");
	}

	/**
	 * Called by the neptune framework, but it has been hijacked to allow for
	 * events. This way we can prevent data loss within the rules component
	 * 
	 * remember that we can only return the this global panel since neptune
	 * framework only loads this one panel.
	 */
	@Override
	public Widget getInstance() {
		panel.clear();
		return panel;
	}

	/**
	 * Populates the panel with the correct contents.
	 * 
	 * @param anchor
	 */
	public void populateTab(String anchor) {
		RulesComponent component = RulesComponent.getInstance();
		NeptuneSecurity security = component.getSecurity();
		component.setCurrentPackage(pkg);
		if (component.hasErrors()) {
			// if component has errors then show as has errors
			setPanelInError();
		} else if (!component.isReady()) {
			// if component is not ready then show as unready
			component.loadCache(anchor);
		} else {
			if (!security.isUserInRole(Permissions.VIEW)) {
				setPanelInError(myConstants.noPermissions());
				return;
			}
			String[] anchorParts = anchor.split("\\?");
			String mainAnchor = "";
			Map<String, String> anchorParams = new HashMap<String, String>();
			if (anchorParts.length > 0)
				mainAnchor = anchorParts[0];
			if (anchorParts.length > 1)
				anchorParams = getParams(anchorParts[1]);

			// fire event with target panel and source panel into the
			// package tab
			if (anchor.isEmpty()) {
				setContents(new RulesListingPanel(pkg));
			} else if (mainAnchor.isEmpty()
					&& anchorParams.containsKey(RulesComponent.existingAnchor)) {
				String idStr = anchorParams.get(RulesComponent.existingAnchor);
				try {
					int id = Integer.parseInt(idStr);
					busyIndicator.center();
					rulesService.getRuleSet(id, getRulesFetchCallback());
				} catch (NumberFormatException ex) {
					setPanelInError(myConstants.invalidRuleSetId());
				}
			} else if (mainAnchor.equalsIgnoreCase(RulesComponent.newAnchor
					.toUpperCase())) {
				if (security.isUserInRole(Permissions.CREATE)) {
					if (anchorParams.containsKey(RulesComponent.SITEID)) {
						handleDefaultSite(anchorParams
								.get(RulesComponent.SITEID));
					} else {
						RulePanel rulePanel = RulePanelFactory.create(pkg);
						UIRuleSet uiRuleSet = new UIRuleSet();
						uiRuleSet.setPackageId(pkg);
						rulePanel.setRule(uiRuleSet);
						setContents(rulePanel);
					}

				} else {
					setPanelInError(myConstants.noPermissions());
					return;
				}
			} else {
				setPanelInError();
			}
		}
	}

	private void handleDefaultSite(String siteIdStr) {
		try {
			final int siteId = Integer.parseInt(siteIdStr);
			busyIndicator.center();
			UiRulesSiteFetcherAsync siteFetcher = GWT
					.create(UiRulesSiteFetcher.class);
			siteFetcher.getSites(new NeptuneAsyncCallback<List<UISite>>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					String msg = "Error loading sites from server.";
					RulesComponent.getInstance().getCurrentTab()
							.setPanelInError(msg);
					busyIndicator.hide();
				}

				@Override
				public void onNeptuneSuccess(List<UISite> result) {
					busyIndicator.hide();
					selectSite(siteId, result);
					RulePanel rulePanel = RulePanelFactory.create(pkg);
					rulePanel.setRule(new UIRuleSet(result, false));
					setContents(rulePanel);
				}
			});
		} catch (NumberFormatException ex) {
			setPanelInError("Invalid siteId.");
		}
	}

	private boolean selectSite(int siteId, List<UISite> sites) {
		for (UISite site : sites) {
			if (site.getId() == siteId) {
				site.setSelected(true);
				return true;
			} else if (selectSite(siteId, site.getChildren())) {
				return true;
			}
		}
		return false;
	}

	private Map<String, String> getParams(String str) {
		Map<String, String> result = new HashMap<String, String>();
		String[] params = str.split("&");
		for (String p : params) {
			String[] paramParts = p.split("=");
			if (paramParts.length == 2) {
				result.put(paramParts[0].toLowerCase(), paramParts[1]);
			}
		}
		return result;
	}

	private AsyncCallback<UIRuleSet> getRulesFetchCallback() {
		return new NeptuneAsyncCallback<UIRuleSet>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				String msg;
				if (caught instanceof RuleSetDoesntExist) {
					msg = myConstants.invalidRuleSetId();
				} else {
					msg = myConstants.errLoadingRuleSet();
				}
				setPanelInError(msg);
			}

			@Override
			public void onNeptuneSuccess(UIRuleSet ruleSet) {
				if (!ruleSet.getPackageId().equals(pkg)) {
					// if you are in the wrong place redirect
					RulesComponent.getInstance().setViewExistingAnchor(
							ruleSet.getPackageId(), ruleSet.getId());
				}
				RulePanel rulePanel = RulePanelFactory.create(ruleSet
						.getPackageId());
				rulePanel.setRule(ruleSet);
				setContents(rulePanel);
				busyIndicator.hide();
			}
		};
	}

	private void setContents(Widget widget) {
		panel.setWidget(widget);
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return new AnchorChangeListener() {

			@Override
			public void anchorChanged(String anchor) {
				populateTab(anchor);
			}

		};
	}

	@Override
	public void release(Widget widget) {
		panel.clear();
	}

	/*
	 * Sets the panel in error state
	 */
	public void setPanelInError(String msg) {
		VerticalContainer box = new VerticalContainer();
		LabelWidget label = new LabelWidget(msg);
		label.addStyleName("red-txt");
		box.add(label);
		setContents(box);
	}

	/*
	 * Sets the panel in error state
	 */
	public void setPanelInError() {
		setPanelInError(myConstants.errLoadingRulesComp());
	}
}
