/**
 * File Name	:	RulesUtils.java
 * Created		: 	Mar 10, 2010 11:20:00 AM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:	
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.rules.ui.client;

import java.util.Collection;

import com.google.gwt.user.client.ui.HasName;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;

/**
 * A utility class for Rules Component. 
 * <p>
 * Has methods like checking if a feature (e.g. Sites) is available.
 * 
 * @author esakhat
 *
 */
public class RulesUtils {

	public static final String SITES_STRING_PREFIX = "";
	public static final String SITES_STRING_SITES_SEPARATOR = ", ";
	public static final String SITES_STRING_ELLIPSIS_SUFFIX = "...";
		
	/**
	 * This would most likely move to Neptune component.
	 */
	public static final String FEATURE_NAME_SITES = "Sites";
	
	/**
	 * Stub value for testing.
	 * This would most likely move to Neptune component.
	 */
	private static final boolean IS_FEATURE_AVAILABLE_SITES = true;
	
	
	/**
	 * 
	 */
	public RulesUtils() {
		super();
	}
	
	/**
	 * Check if an Application feature is available.
	 * <p>
	 * This would most likely move to Neptune component.
	 * 
	 * @param featureName
	 * @return
	 */
	public static boolean isFeatureAvailable(String featureName) {
		boolean isFeatureAvailable = false;
		
		if (FEATURE_NAME_SITES.equals(featureName)) {
			isFeatureAvailable = IS_FEATURE_AVAILABLE_SITES;
		}
		return isFeatureAvailable;
	}

	public static String getSitesString(Collection<UISite> sites, int length) {
		String sitesString = SITES_STRING_PREFIX;

		int sitesStringLength = sitesString.length();
		boolean firstSite = true;
		for (UISite uiSite : sites) {
			sitesStringLength = sitesString.length();
			String siteString = uiSite.getName();

			int siteStringLength = siteString.length();
			if (firstSite) {
				firstSite = false;
				if (siteStringLength > length - SITES_STRING_PREFIX.length()) {
					sitesString += siteString.substring(0, length
							- SITES_STRING_PREFIX.length()
							- SITES_STRING_ELLIPSIS_SUFFIX.length());
					sitesString += SITES_STRING_ELLIPSIS_SUFFIX;
					break;
				}
			} else if (sitesStringLength > SITES_STRING_PREFIX.length()) {
				siteString = SITES_STRING_SITES_SEPARATOR + siteString;
			}

			sitesStringLength = sitesString.length();
			if ((sitesStringLength + siteStringLength) < length - SITES_STRING_PREFIX.length()) {
				sitesString += siteString;
			} else {
				sitesString += SITES_STRING_SITES_SEPARATOR
						+ SITES_STRING_ELLIPSIS_SUFFIX;
				break;
			}
		}

		return sitesString;
	}
	
	public static String getNamesString(Collection<? extends HasName> items) {
		StringBuffer itemsString = new StringBuffer();

		for (HasName item : items) {
			String str = item.getName();
			if(itemsString.length() > 0)
				itemsString.append(SITES_STRING_SITES_SEPARATOR);
			itemsString.append(str);
		}
		return itemsString.toString();
	}
	
	/**
	 * @return the schedulerLicensed
	 */
	public static boolean isSchedulerLicensed() {
		return RulesComponent.getInstance().isSchedulerLicensed();
	}

}
