package com.tandbergtv.cms.rules.ui.client;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/rules/uiRulesService")
public interface UiRulesService extends RemoteService {

	/**
	 * Retrieves a shallow representation of a list of rule sets.
	 * 
	 * @param packageName The name of the package you wish to retrieve the 
	 * @return
	 * @throws NeptuneException
	 */
	public List<UIRuleListItem> getRuleSetsByPackage(String packageName)
			throws NeptuneException;

	/**
	 * Saves the order of the rulesets
	 * 
	 * @param packageName
	 * @param list
	 */
	public void saveRuleSetOrder(String packageName, List<UIRuleListItem> list)
			throws NeptuneException;

	/**
	 * 
	 * @param ruleSetId
	 * @return
	 * @throws NeptuneException
	 */
	public UIRuleSet getRuleSet(int ruleSetId) throws NeptuneException;

	/**
	 * Saves a rule set.
	 * 
	 * @param ruleSet
	 *            The RuleSet you wish to persist.
	 * @return
	 * @throws NeptuneException
	 */
	public int saveRuleSet(UIRuleSet ruleSet) throws NeptuneException;

	/**
	 * Deletes a list of ruleSets based on the RuleSet ids
	 * 
	 * @param ruleSetId
	 *            The Ids of the ruleSets you wish to delete.
	 * @throws NeptuneException
	 */
	public void deleteRuleSet(List<Integer> ruleSetIds) throws NeptuneException;

	/**
	 * Saves and Runs ruleSet against all titles
	 * 
	 * @param ruleSet
	 *            The rule set you wish to save and run
	 * @throws NeptuneException
	 */
	public void saveAndRunRuleSet(UIRuleSet ruleSet) throws NeptuneException;
	
	/**
	 * Enables the rule sets corresponding to the rule set ids provided.
	 * @param ruleSetIds
	 * @throws NeptuneException
	 */
	public void enableRuleSets(List<Integer> ruleSetIds) throws NeptuneException;
	
	/**
	 * Disables the rule sets corresponding to the rule set ids provided.
	 * @param ruleSetIds
	 * @throws NeptuneException
	 */
	public void disableRuleSets(List<Integer> ruleSetIds) throws NeptuneException;

	/**
	 * Returns the Package type of a rule set based on the ruleSetId
	 * @param ruleSetId
	 * @return
	 * @throws NeptuneException 
	 */
	Packages getPackageType(int ruleSetId) throws NeptuneException;

	/**
	 * gets the custom rules
	 * @param packageName
	 * @return
	 * @throws NeptuneException
	 */
	UiCustomRuleTree getCustomRules(String packageName) throws NeptuneException;
	
	boolean customRulesExist(String packageName) throws NeptuneException;

}
