/**
 * 
 */
package com.tandbergtv.cms.rules.ui.client;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * @author dweiner
 * @generated generated asynchronous callback interface to be used on the client side
 *
 */
public interface UiRulesServiceAsync {

	/**
	 * Retrieves a shallow representation of a list of rule sets.
	 * 
	 * @param packageName The name of the package you wish to retrieve the 
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getRuleSetsByPackage(String packageName,
			AsyncCallback<List<UIRuleListItem>> callback);

	/**
	 * Saves the order of the rulesets
	 * 
	 * @param packageName
	 * @param list
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void saveRuleSetOrder(String packageName, List<UIRuleListItem> list,
			AsyncCallback<?> callback);

	/**
	 * 
	 * @param ruleSetId
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getRuleSet(int ruleSetId, AsyncCallback<UIRuleSet> callback);

	/**
	 * Saves a rule set.
	 * 
	 * @param ruleSet
	 *            The RuleSet you wish to persist.
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void saveRuleSet(UIRuleSet ruleSet, AsyncCallback<Integer> callback);

	/**
	 * Deletes a list of ruleSets based on the RuleSet ids
	 * 
	 * @param ruleSetId
	 *            The Ids of the ruleSets you wish to delete.
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void deleteRuleSet(List<Integer> ruleSetIds, AsyncCallback<?> callback);

	/**
	 * Saves and Runs ruleSet against all titles
	 * 
	 * @param ruleSet
	 *            The rule set you wish to save and run
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void saveAndRunRuleSet(UIRuleSet ruleSet, AsyncCallback<?> callback);

	/**
	 * Enables the rule sets corresponding to the rule set ids provided.
	 * @param ruleSetIds
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void enableRuleSets(List<Integer> ruleSetIds, AsyncCallback<?> callback);

	/**
	 * Disables the rule sets corresponding to the rule set ids provided.
	 * @param ruleSetIds
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void disableRuleSets(List<Integer> ruleSetIds, AsyncCallback<?> callback);

	/**
	 * Returns the Package type of a rule set based on the ruleSetId
	 * @param ruleSetId
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getPackageType(int ruleSetId, AsyncCallback<Packages> callback);

	void getCustomRules(String packageName, AsyncCallback<UiCustomRuleTree> callback) throws NeptuneException;
	
	void customRulesExist(String packageName, AsyncCallback<Boolean> callback) throws NeptuneException;
}
