package com.tandbergtv.cms.rules.ui.client.common;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Grid;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIEvent;
import com.tandbergtv.cms.rules.ui.client.data.UIEventType;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class EventSelectPanel extends VerticalContainer implements Validatable {

	private static final int NUM_COL_PER_ROW = 9;
	private List<EventSelectPanelData> checkBoxes;

	public EventSelectPanel(UIRuleSet ruleSet) {
		setCheckBoxes(ruleSet.getPackageId());

		int numRecords = checkBoxes.size();
		int numRows = numRecords / NUM_COL_PER_ROW;
		if (numRecords % NUM_COL_PER_ROW > 0) {
			numRows++;
		}
		Grid g = new Grid(numRows, NUM_COL_PER_ROW);
		g.setCellSpacing(5);
		int currRow = 0;
		int currCol = 0;

		for (EventSelectPanelData cb : checkBoxes) {
			for (UIEvent e : ruleSet.getEvents()) {
				if (e.getEventType().equals(cb.eventType)) {
					cb.checkBox.setValue(true);
				}
			}
			g.setWidget(currRow, currCol, cb.checkBox);
			g.getCellFormatter().addStyleName(currRow, currCol, "event-grid-cell");
			if (++currCol == NUM_COL_PER_ROW) {
				currCol = 0;
				currRow++;
			}

		}

		add(g);
	}

	private void setCheckBoxes(Packages tpackage) {
		checkBoxes = new ArrayList<EventSelectPanelData>();
		CheckBoxWidget checkBox = null;
		RulesConstants myConstants = (RulesConstants) GWT
				.create(RulesConstants.class);

		checkBox = new CheckBoxWidget(myConstants.ingest());
		checkBox.setTitle(myConstants.ingestTitle());
		checkBoxes.add(new EventSelectPanelData(UIEventType.INGESTED,
				checkBox));

		checkBox = new CheckBoxWidget(myConstants.uiCreate());
		checkBox.setTitle(myConstants.uiCreateTitle());
		checkBoxes.add(new EventSelectPanelData(UIEventType.UICREATED,
				checkBox));

		checkBox = new CheckBoxWidget(myConstants.uiUpdate());
		checkBox.setTitle(myConstants.uiUpdateTitle());
		checkBoxes.add(new EventSelectPanelData(UIEventType.UIUPDATED,
				checkBox));
		if(tpackage != Packages.NORMALIZATION) {
			checkBox = new CheckBoxWidget(myConstants.normalized());
			checkBox.setTitle(myConstants.nationalizeTitle());
			checkBoxes.add(new EventSelectPanelData(UIEventType.NORMALIZED,
					checkBox));
			CheckBoxWidget purgeCheckBox = new CheckBoxWidget(myConstants.purge());
			purgeCheckBox.setTitle(myConstants.purgeTitle());
			checkBoxes.add(new EventSelectPanelData(UIEventType.PURGE,
					purgeCheckBox));
			checkBox = new CheckBoxWidget(myConstants.deleted());
			checkBox.setTitle(myConstants.deleted());
			checkBoxes.add(new EventSelectPanelData(UIEventType.DELETED,
					checkBox));
		}

		CheckBoxWidget targetCheckBox = new CheckBoxWidget(myConstants.targeted());
		targetCheckBox.setTitle(myConstants.targetedTitle());
		checkBoxes.add(new EventSelectPanelData(UIEventType.TARGETED,
				targetCheckBox));
	}

	public List<EventSelectPanelData> getCheckBoxes() {
		return checkBoxes;
	}

	/**
	 * Grab selected events from panel and return as a list
	 * 
	 * @param panelEventSelect
	 * @return
	 */
	public List<UIEvent> getEvents() {
		// return empty for now, events are not implemented
		List<UIEvent> events = new ArrayList<UIEvent>(checkBoxes.size());

		for (EventSelectPanelData cb : checkBoxes) {
			if (cb.checkBox.getValue()) {
				events.add(new UIEvent(cb.eventType, cb.checkBox.getValue()));
			}
		}
		return events;
	}

	@Override
	public boolean validate() {
		return true;
	}
}

class EventSelectPanelData {
	UIEventType eventType;
	CheckBoxWidget checkBox;

	public EventSelectPanelData(UIEventType eventType, CheckBoxWidget checkBox) {
		super();
		this.eventType = eventType;
		this.checkBox = checkBox;
	}

}
