package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * This is used to put together simple panels for the rules so that we don't have to create classes
 * for every little widget.  For example I didn't want to create a special class for Rule Name since 
 * @author dweiner
 *
 */
public class RuleNamePanel extends VerticalContainer implements Validatable, IMessageEmitter {
	
	protected TextBoxWidget txtRuleName;
	protected RulesConstants myConstants = (RulesConstants) GWT.create(RulesConstants.class);
	protected boolean hasBeenValidatedBefore=false;
	private CheckBoxWidget ruleEnabled = new CheckBoxWidget();
	private HorizontalContainer mainContainer = new HorizontalContainer();
	protected IMessageListener messageListener;
	
	public RuleNamePanel() {
		//by default we set enabled to true
		ruleEnabled.setValue(true);
		putUiTogether();
	}
	
	public RuleNamePanel(String ruleName, boolean enabled) {
		putUiTogether();
		txtRuleName.setValue(ruleName);
		ruleEnabled.setValue(enabled);
	}
	
	protected void putUiTogether() {
		add(mainContainer);
		LabelWidget labelRule = new LabelWidget(myConstants.ruleNameLabel());
		txtRuleName = new TextBoxWidget();
		txtRuleName.setMaxLength(255);
		txtRuleName.setVisibleLength(100);
		txtRuleName.addStyleName("small-txt");
		mainContainer.add(labelRule);
		mainContainer.add(txtRuleName);
		
		ruleEnabled.setText(myConstants.enabledLabel());
		mainContainer.add(ruleEnabled);
		
		this.setCellHorizontalAlignment(mainContainer, ALIGN_LEFT);
		//mainContainer.setCellHorizontalAlignment(ruleEnabled, ALIGN_RIGHT);
	}
	
	@Override
	public boolean validate() {
		if(txtRuleName.getText().equals("")){
			showWarningMessage(myConstants.ruleNameRequired());
			txtRuleName.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
			if(!hasBeenValidatedBefore) {
				txtRuleName.addChangeHandler(new ChangeHandler(){

					@Override
					public void onChange(ChangeEvent event) {
						clearWarningMessages();
						txtRuleName.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
					}
					
				});
			}
			return false;
		}
		return true;
	}
	
	public String getRuleName() {
		return txtRuleName.getText();
	}
	
	public boolean isEnabled() {
		return ruleEnabled.getValue();
	}
	
	public void setEnabled(boolean enabled) {
		ruleEnabled.setValue(enabled);
	}
	
	public CheckBoxWidget getRuleEnabled() {
		return ruleEnabled;
	}
	
	private void clearWarningMessages() {
		resetMessagePanel();
	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
	}
	
	public void showInfoMessage(String infoMsg) {
		if (messageListener != null) {
			messageListener.setInfoMessage(infoMsg);
		}
	}
	
	public void showErrorMessage(String errorMessage) {
		if (messageListener != null) {
			messageListener.setErrorMessage(errorMessage);
		}
	}

	public void showWarningMessage(String warningMessage) {
		showErrorMessage(warningMessage);
	}
	
	public void resetMessagePanel() {
		if (messageListener != null) {
			messageListener.reset();
		}
	}

}
