package com.tandbergtv.cms.rules.ui.client.common;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldProviderResults;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfilesList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.ContentClassInfo;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.rules.ui.client.LicensingDataProviderResults;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.UiEnhancementRulesDataProvider;
import com.tandbergtv.cms.rules.ui.client.UiEnhancementRulesDataProviderAsync;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProvider;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProviderAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiRuleType;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.normalization.ActionDataTypeSpecificFieldSelector;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionFieldSelector;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * This is an abstract class the for the Rule Set Details page.
 * 
 * @author dweiner
 * 
 */
public abstract class RulePanel extends VerticalContainer implements IMessageEmitter {

	protected RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	protected RulesMessages ruleMessages = (RulesMessages) GWT
			.create(RulesMessages.class);
	protected final UiRulesServiceAsync rulesService = GWT
			.create(UiRulesService.class);
	private final IContentClassProviderAsync contentClassProvider = GWT
			.create(IContentClassProvider.class);
	private final UiEnhancementRulesDataProviderAsync enhancementDataProvider = GWT
			.create(UiEnhancementRulesDataProvider.class);

	protected UIRuleSet ruleSet;
	protected HeaderPanel headerPanel = new HeaderPanel("");
	protected MessageContainer messageContainer = new MessageContainer();
	private boolean loadedContract = false;
	private boolean loadedSpec = false;
	private boolean loadedFieldOptions = false;
	protected boolean loadedEnhancementOptions = false;

	protected IMessageListener messageListener;

	public RulePanel() {
		setHorizontalAlignment(ALIGN_CENTER);
		setStylePrimaryName("rules-RulePanel");
	}

	/**
	 * Clears this container and displays the rule set provided.
	 * 
	 * @param ruleSet
	 *            The rule set to display.
	 */
	public void setRule(final UIRuleSet ruleSet) {
		this.ruleSet = ruleSet;
		load();
	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
	}	

	public void showInfoMessage(String infoMsg) {
		if (messageListener != null) {
			messageListener.setInfoMessage(infoMsg);
		}
	}
	
	public void showErrorMessage(String errorMessage) {
		if (messageListener != null) {
			messageListener.setErrorMessage(errorMessage);
		}
	}

	public void showErrorHTML(String errorHTML) {
		if (messageListener != null) {
			messageListener.setErrorHTML(errorHTML);
		}
	}

	public void showWarningMessage(String warningMessage) {
		showErrorMessage(warningMessage);
	}
	
	public void resetMessagePanel() {
		if (messageListener != null) {
			messageListener.reset();
		}
	}

	public void showErrorMessages(List<String> messages) {
		String errorHTML = getHTML(messages);
		if ((errorHTML != null) && (!errorHTML.isEmpty())) {
			showErrorHTML(errorHTML);
		}
	}
	
	protected String getHTML(List<String> messages) {
		String html = null;
		
		if ((messages != null) && (messages.size() > 0)) {
			html = "";
			for (String message : messages) {
				html += message + "<br>";
			}
		}
		
		return html;
	}
	
	protected void load() {
		clear();
		add(headerPanel);
		IMdmFieldProviderAsync specManagerService =  GWT.create(IMdmFieldProvider.class);
		specManagerService.getFields(TreeCreator.getSpecLastUpdateDate(), new NeptuneAsyncCallback<FieldProviderResults>() {
			public void onNeptuneFailure(Throwable caught) {
				showErrorMessage(
						"Error loading metadata specification.");
			}

			public void onNeptuneSuccess(FieldProviderResults result) {
				// set spec and fire event to change tab contents
				if(result.requiresUpdate())
					TreeCreator.setSpec(result);
				loadedSpec = true;
				checkLoaded();
			}
		});

		UiLicenseDataProviderAsync licFetcher = GWT.create(UiLicenseDataProvider.class);
		licFetcher.getContractField(TreeCreator.getContractLastUpdateDate(), new NeptuneAsyncCallback<LicensingDataProviderResults>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				showErrorMessage(
						"Error loading Licensing Information.");
			}

			@Override
			public void onNeptuneSuccess(LicensingDataProviderResults result) {
				if(result.needsUpdate())
					TreeCreator.setContractData(result.getTree(), result.getLastUpdateDate());
				loadedContract = true;
				checkLoaded();
			}
		});

		contentClassProvider.getContentClassInfo(new NeptuneAsyncCallback<ContentClassInfo>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				showErrorMessage(
								"Error loading Content Classes.");
			}

			@Override
			public void onNeptuneSuccess(ContentClassInfo result) {
				PMMFieldProvider.setContentClasses(result.getContentClasses());
				AssetFieldTreeObject.setFieldOptions(result.getContentClassOptions());
				loadedFieldOptions = true;
				checkLoaded();
			}
		});
		
		enhancementDataProvider.getSubscritionProvides(TreeCreator.getMeLastUpdateDate(), new NeptuneAsyncCallback<UiSubscriptionProfilesList>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				showErrorMessage(
						"Error metadata enhancement fields.");
			}

			@Override
			public void onNeptuneSuccess(UiSubscriptionProfilesList result) {
				if (result.isRefreshed()) {
					TreeCreator.setSubscriptionProfiles(result.getUiSubscriptionProfiles(), result.getLastUpdatedDate());
				}
				loadedEnhancementOptions  = true;
				checkLoaded();
			}
		});
	}
	
	private void checkLoaded() {
		if(loadedSpec && loadedContract && loadedFieldOptions && loadedEnhancementOptions) {
			NormalizationActionFieldSelector.clearCache();
			ActionDataTypeSpecificFieldSelector.clearCache();
			createPanel();
		}
	}

	/**
	 * Set the heading of this rule panel, this is currently only used by
	 * subclasses. But we can modify this to take in more
	 * 
	 * @param headerString
	 */
	public void setHeaderLabel(String headerString) {
		headerPanel.setLabel(headerString);
	}

	/**
	 * Default click handler for cancel button returns to listing page
	 * 
	 * @return
	 */
	protected ClickHandler getDefaultCancelHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {
				History.back();
			}
		};
	}

	/**
	 * Not being used, but here for throughness
	 * 
	 * @return
	 */
	protected ClickHandler getDefaultSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {
				// do nothing
			}
		};
	}

	/**
	 * Since the save will vary for different types of rules the save button
	 * will need to be implemented by the extending class.
	 */
	protected abstract void createPanel();

	protected void handleSiteJobAssoc(UiRuleSetsAssocWJobExpception caught) {
		UiRuleSetsAssocWJobExpception e = (UiRuleSetsAssocWJobExpception) caught;
		List<UiRuleSetJobsAssoc> issues = e.getIssues();

		resetMessagePanel();

		String errorHTML;
		
		if (issues.size() > 0) {
			errorHTML = "";
			// go thru each reason (one per rulset)
			for (UiRuleSetJobsAssoc issue : issues) {
				String siteName = issue.getSiteName();
				String jobNames = issue.getJobNames();
				errorHTML += ruleMessages.ruleSiteAssocErr(
						siteName, jobNames);
				errorHTML += "<br>";
			}
			
			showErrorHTML(errorHTML);
		}
	}
	
	protected boolean failsContractValidate(List<UiRule> rules) {
		for(UiRule rule : rules) {
			if(rule.getRuleType().equals(UiRuleType.STANDARD_RULE)) {
				UiStandardRule sr = (UiStandardRule) rule;
				IUITitleFilterNode node = sr.getUiTitleFilterNode();
				
				boolean fails = contractValidateHelper(node)
						|| contractValidateHelper(sr.getActions());
				if(fails)
					return true;
			}
		}
		return false;
	}
	
	/*
	 * Creates cancel button with no handler just looks the part
	 */
	protected ButtonWidget createCancelButton() {
		ButtonWidget button = new ButtonWidget(myConstants.cancel());
		button.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		return button;
	}

	/*
	 * Creates cancel button with no handler just looks the part
	 */
	protected ButtonWidget createSaveButton() {
		ButtonWidget button = new ButtonWidget(myConstants.save());
		button.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		return button;
	}

	private boolean contractValidateHelper(IUITitleFilterNode node) {
		if(node instanceof UITitleFilterListNode) {
			UITitleFilterListNode list = (UITitleFilterListNode) node;
			for(IUITitleFilterNode child : list.getList()) {
				if(contractValidateHelper(child))
					return true;
			}
		} else if (node instanceof UITitleFilterValueNode) {
			UITitleFilterValueNode value = (UITitleFilterValueNode) node;
			return value.getFieldType().equals(UIFieldType.LICENSE);
		} else if (node instanceof UITitleFilterRHSFieldNode) {
			UITitleFilterRHSFieldNode rhsFieldNode = (UITitleFilterRHSFieldNode) node;
			return rhsFieldNode.getFieldType().equals(UIFieldType.LICENSE)
					|| rhsFieldNode.getFieldTypeRhs().equals(UIFieldType.LICENSE);
		}
		return false;
	}
	
	private boolean contractValidateHelper(List<UIAction> actions) {
		for(UIAction action : actions) {
			UIActionParam assetTypeLhs = action.getParam(ActionParams.SECTIONTYPE);
			UIActionParam assetTypeRhs = action.getParam(ActionParams.SECTIONTYPERHS);
			if ((assetTypeLhs != null && assetTypeLhs.getValue().equals(
					"LICENSE"))
					|| (assetTypeRhs != null && assetTypeRhs.getValue().equals(
							"LICENSE")))
				return true;
		}
		return false;
	}
}
