package com.tandbergtv.cms.rules.ui.client.common;

import com.tandbergtv.cms.rules.ui.client.contentprocessing.ContentProcessingRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.licenseassignment.LicAssignmentRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.msooverride.MsoOverrideRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.targeting.TargetingRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.prioritization.PrioritizationRuleSetPanel;

public class RulePanelFactory {
	
	public static RulePanel create(Packages pkgType) {
		switch (pkgType) {
		case VALIDATION:
			return new ValidationRuleSetPanel();
		case NORMALIZATION:
			return new NormalizationRuleSetPanel();
		case PROCESSING:
			return new ContentProcessingRuleSetPanel();
		case TARGETING:
			return new TargetingRuleSetPanel();
		case PRIORITIZATION:
			return new PrioritizationRuleSetPanel();
		case LICENSING:
			return new LicAssignmentRuleSetPanel();
		case MSOOVERRIDE:
			return new MsoOverrideRuleSetPanel();
		default:
			return null;
		}
	}
}
