package com.tandbergtv.cms.rules.ui.client.common;

import java.util.Collection;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.EmptyRHS;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueDateBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;

public class RulesActionValueFactory {
	
	public static SingleValueWidget getRHSWidget(IFieldTreeObject treeObject,
			UIAction action, String value) {

		// If we can't build anything yet go ahead and return an empty text box
		if (treeObject == null || action == null) {
			return new ValueTextBox(new StringValidator());
		}
		UIDataType fieldDataType = treeObject.getDataType();
		String dataTypeStr;
		if(fieldDataType != null)
			dataTypeStr = fieldDataType.value();
		else
			dataTypeStr = NormalizationActionBox.COMPLEX;

		UIDataType dataType = action.getValueTypeMap().get(dataTypeStr);

		Collection<UIValueOption> suggestedValues = null; 
		if (action.useSuggestedValues() && treeObject.supportsSuggestValues()) {
			suggestedValues = treeObject.getSuggestedValues();
		}
		switch(dataType) {
		case COMPLEX:
			return new EmptyRHS();
		case INTEGER:
			return buildValTextBox(new LongValidator(), value, suggestedValues, treeObject.supportsOther());
		case STRING:
			return buildValTextBox(new StringValidator(), value, suggestedValues, treeObject.supportsOther());
		case BOOLEAN:
			return BuildBooleanBox(value);
		case FLOAT:
			return buildValTextBox(new FloatValidator(), value, suggestedValues, treeObject.supportsOther());
		case DATE:
			return buildDateBox(value);
		case TIME:
			return buildValTextBox(new TimeValidator(), value, suggestedValues, treeObject.supportsOther());
		default:
			return new ValueTextBox(new StringValidator());
		}
	}

	private static SingleValueWidget buildValTextBox(IRulesValidator validator,
			String value, Collection<UIValueOption> suggestedValues, boolean supportsOther) {
		if ((value == null || value.isEmpty()) && suggestedValues == null) {
			return new ValueTextBox(validator);
		} else if (value == null || value.isEmpty()) {
			return new ValueTextBox(validator, suggestedValues, supportsOther);
		} else if (suggestedValues == null) {
			return new ValueTextBox(validator, value);
		} else {
			return new ValueTextBox(validator, suggestedValues, supportsOther, value);
		}
	}

	private static SingleValueWidget buildDateBox(String value) {
		if (value == null || value.isEmpty()) {
			return new ValueDateBox();
		} else {
			return new ValueDateBox(value);
		}
	}

	private static SingleValueWidget BuildBooleanBox(String value) {
		if (value == null || value.isEmpty()) {
			return new ValueBooleanBox();
		} else {
			return new ValueBooleanBox(value);
		}
	}
}
