package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

public class RulesConfirmation extends DialogBox {

	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private HorizontalPanel buttonPanel = new HorizontalPanel();

	private RulesConfirmation(String msg) {
		super(false, true);
		buttonPanel.add(createOkButton());
		buttonPanel.add(createNoButton());
		setHTML(msg);
		setWidget(buttonPanel);
		center();
	}

	/**
	 * Show a modal confirmation dialogue.
	 * 
	 * @param msg
	 * @param handler
	 */
	public static void show(String msg, ConfirmationHandler handler) {
		RulesComponent component = RulesComponent.getInstance();
		HandlerManager hman = component.getHandlerManager();
		hman.addHandler(ConfirmationEvent.TYPE, handler);
		RulesConfirmation confirmBox = new RulesConfirmation(msg);
		confirmBox.show();
	}

	private ButtonWidget createOkButton() {
		String title = myConstants.yes();
		return new ButtonWidget(title, new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				fireEvent(new ConfirmationEvent(true));
			}
		});
	}

	private ButtonWidget createNoButton() {
		String title = myConstants.no();
		return new ButtonWidget(title, new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				fireEvent(new ConfirmationEvent(false));
			}
		});
	}

	private void fireEvent(ConfirmationEvent e) {
		HandlerManager hman = RulesComponent.getInstance().getHandlerManager();
		hman.fireEvent(e);
		hide();
	}
}
