/**
 * File Name	:	SchedulePanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 19, 2011 12:43:10 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.rules.ui.client.common;

import java.util.List;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget2;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetFactory;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SchedulePanel extends VerticalContainer  implements Validatable, IMessageEmitter {

	CheckBoxWidget cbSchedule;
	SchedulingWidget2 schedulingWidget;
	
	RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);

	IMessageListener messageListener;
	
	public SchedulePanel() {

		cbSchedule = new CheckBoxWidget(myConstants.scheduleCheckBox());
		add(cbSchedule);
	
		SchedulingWidgetConfig widgetConfig = new SchedulingWidgetConfig();
		widgetConfig.setShowOnDateRow(true);
		widgetConfig.setShowEveryNDaysRow(true);
		widgetConfig.setShowOnDayEveryNWeeksRow(true);
		widgetConfig.setShowNDaysFromMetadataRow(false);
		schedulingWidget = SchedulingWidgetFactory.create2(widgetConfig);
		   
		schedulingWidget.setVisible(false);
		add(schedulingWidget);
		
		cbSchedule.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				boolean checked = ((CheckBoxWidget) event.getSource()).getValue();
				if (checked) {
					schedulingWidget.setVisible(true);
				}
				else {
					confirm(myConstants.confirmScheduleDeletion(),
							new Command() {

								@Override
								public void execute() {
									schedulingWidget.setVisible(false);
								}
							}, new Command() {

								@Override
								public void execute() {
									cbSchedule.setValue(true);

								}
							});

				}
			}
		});
	}
	
	public SchedulePanel(ScheduleInfo scheduleInfo) {
		this();
		schedulingWidget.setScheduleInfo(scheduleInfo);
		if (scheduleInfo != null) {
			cbSchedule.setValue(true);
			schedulingWidget.setVisible(true);
		}
	}
	
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = null;
		
		if (cbSchedule.getValue()) {
			scheduleInfo = schedulingWidget.getScheduleInfo();
		}
		
		return scheduleInfo;
	}
	
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		if (scheduleInfo != null) {
			cbSchedule.setValue(true);
			schedulingWidget.setScheduleInfo(scheduleInfo);
		}
	}

	@Override
	public boolean validate() {
		boolean validateResult = true;
		
		clearWarningMessages();
		if (cbSchedule.getValue()) {
			List<String> validationMessages = schedulingWidget.validate();
			if (validationMessages.size() > 0) {
				validateResult = false;
				showErrorMessages(validationMessages);
			}
		}
		
		return validateResult;
	}
	
	public void addWarningMessages(List<String> msgs) {
		showErrorMessages(msgs);
	}

	public void clearWarningMessages() {
		resetMessagePanel();
	}
	
	/**
	 * 
	 * @param enabled
	 */
	public void setCheckBoxEnabled(boolean enabled) {
		cbSchedule.setEnabled(enabled);
	}
	
	/**
	 * 
	 * @param enabled
	 */
	public void setScheduleEnabled(boolean enabled) {
		schedulingWidget.setEnabled(enabled);
	}

	private void confirm(String confirmationText, final Command okCommand,
			final Command cancelCommand) {
		final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
		dialogBox.setText(confirmationText);

		// yes button
		ButtonWidget yesButton = new ButtonWidget(myConstants.buttonLabelOk());
		yesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if (okCommand != null)
					okCommand.execute();
			}
		});

		// no button
		ButtonWidget noButton = new ButtonWidget(myConstants.buttonLabelCancel());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if (cancelCommand != null)
					cancelCommand.execute();
			}
		});

		// panel which contains the buttons
		HorizontalContainer buttonPanel = new HorizontalContainer();
		dialogBox.setWidget(buttonPanel);
		buttonPanel.add(yesButton);
		buttonPanel.setCellHorizontalAlignment(yesButton,
				HorizontalPanel.ALIGN_RIGHT);
		buttonPanel.add(noButton);
		buttonPanel.setCellHorizontalAlignment(noButton,
				HorizontalPanel.ALIGN_LEFT);

		dialogBox.center();
		dialogBox.show();
	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
	}
	
	public void showInfoMessage(String infoMsg) {
		if (messageListener != null) {
			messageListener.setInfoMessage(infoMsg);
		}
	}
	
	public void showErrorMessage(String errorMessage) {
		if (messageListener != null) {
			messageListener.setErrorMessage(errorMessage);
		}
	}

	public void showErrorHTML(String errorHTML) {
		if (messageListener != null) {
			messageListener.setErrorHTML(errorHTML);
		}
	}

	public void showWarningMessage(String warningMessage) {
		showErrorMessage(warningMessage);
	}
	
	public void resetMessagePanel() {
		if (messageListener != null) {
			messageListener.reset();
		}
	}

	public void showErrorMessages(List<String> messages) {
		String errorHTML = getHTML(messages);
		if ((errorHTML != null) && (!errorHTML.isEmpty())) {
			showErrorHTML(errorHTML);
		}
	}

	protected String getHTML(List<String> messages) {
		String html = null;
		
		if ((messages != null) && (messages.size() > 0)) {
			html = "";
			for (String message : messages) {
				html += message + "<br>";
			}
		}
		
		return html;
	}
	
}
