/**
 * File Name	:	TabItem.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Oct 8, 2012 5:59:16 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class TabItem extends Composite implements Validatable, IMessageEmitter {

	protected static final String STYLE_NAME_TAB_ITEM = "tabbed-wizard-tabItem";
	protected static final String STYLE_NAME_INSTRUCTIONS = "wizard-instructions";
	protected static final int DEFAULT_SPACING = 10; 
	
	protected VerticalContainer mainContainer = new VerticalContainer();
	protected String instructions;
	protected Widget widget;
	protected LabelWidget instructionsLabel;
	
	// message listener
	protected IMessageListener messageListener;
	
	/**
	 * 
	 */
	public TabItem(String instructions, Widget widget) {
		this.instructions = instructions;
		this.widget = widget;
		
		initWidget(mainContainer);
		
		instructionsLabel = new LabelWidget();
		instructionsLabel.setText(instructions);
		instructionsLabel.setStyleName("rules-wizard-instructions");

		mainContainer.setSpacing(DEFAULT_SPACING);
		
		mainContainer.add(instructionsLabel);

		mainContainer.add(widget);
	}

	@Override
	public boolean validate() {
		boolean isValid = true;
		
		if (widget instanceof Validatable) {
			isValid = ((Validatable) widget).validate();
		}
		
		return isValid;
	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
		
		if (widget instanceof IMessageEmitter) {
			IMessageEmitter messageEmitter = (IMessageEmitter) widget;
			messageEmitter.registerMessageListener(messageListener);
		}
	}	
	
	public void showInfoMessage(String infoMsg) {
		if (messageListener != null) {
			messageListener.setInfoMessage(infoMsg);
		}
	}
	
	public void showErrorMessage(String errorMessage) {
		if (messageListener != null) {
			messageListener.setErrorMessage(errorMessage);
		}
	}

	public void resetMessagePanel() {
		if (messageListener != null) {
			messageListener.reset();
		}
	}

}
