/**
 * File Name	:	TabbedWizard.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Oct 3, 2012 5:40:30 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.rules.ui.client.common;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class TabbedWizard extends ResizableContainer {

	protected static final String STYLE_NAME_TABBED_WIZARD = "tabbed-wizard";
	protected static final String STYLE_NAME_COMMON_BUTTONS_PANEL = "tabbed-wizard-common-buttons-panel";
	
	protected ButtonWidget prevButton;
	protected ButtonWidget nextButton;
	protected HorizontalContainer commonButtonsPanel;
	
	protected boolean isNewRule = true;
	protected int currentIndex = 0; 
	protected int highestVisitedIndex = 0;
	
	protected List<String> tabTitlesList = new ArrayList<String>();
	
	private RulesConstants rulesConstants = RulesComponent.getInstance()
			.getConstants();

	/**
	 * @param content
	 * @param tabTitle
	 * @param anchorPrefix
	 */
	public TabbedWizard(Widget content, String tabTitle, String anchorPrefix) {
		super(content, tabTitle, anchorPrefix);
		
		tabTitlesList.add(tabTitle);

		commonButtonsPanel = new HorizontalContainer();
		commonButtonsPanel.addStyleName(STYLE_NAME_COMMON_BUTTONS_PANEL);
		
		prevButton = createPrevButton();
		nextButton = createNextButton();
		
		commonButtonsPanel.add(prevButton);
		commonButtonsPanel.add(nextButton);

		mainContainer.add(commonButtonsPanel);
		addHeightOffsettingWidget(commonButtonsPanel);
		
		tabContainer.addSelectionHandler(new SelectionHandler<Integer>() {

			@Override
			public void onSelection(SelectionEvent<Integer> event) {
				int selectedTabIndex = event.getSelectedItem();
				currentIndex = selectedTabIndex;
				int numTabs = getNumTabs();
				if (isNewRule) {
					if (currentIndex <= 0) {
						prevButton.setVisible(false);
						nextButton.setVisible(true);
					} else if (currentIndex < numTabs - 1) {
						prevButton.setVisible(true);
						nextButton.setVisible(true);
					} else if (currentIndex >= numTabs - 1) {
						prevButton.setVisible(true);
						nextButton.setVisible(false);
					}
				}
			}
			
		});

		addStyleName(STYLE_NAME_TABBED_WIZARD);
			
	}

	/**
	 * @param content
	 * @param tabTitle
	 * @param anchorPrefix
	 * @param extMessageArea
	 */
	public TabbedWizard(Widget content, String tabTitle, String anchorPrefix,
			MessageArea extMessageArea) {
		super(content, tabTitle, anchorPrefix, extMessageArea);
	}

	/**
	 * @param leftContent
	 * @param rightContent
	 * @param tabTitle
	 * @param anchorPrefix
	 */
	public TabbedWizard(Widget leftContent, Widget rightContent,
			String tabTitle, String anchorPrefix) {
		super(leftContent, rightContent, tabTitle, anchorPrefix);
	}

	/**
	 * @param leftContent
	 * @param rightContent
	 * @param tabTitle
	 * @param anchorPrefix
	 * @param extMessageArea
	 */
	public TabbedWizard(Widget leftContent, Widget rightContent,
			String tabTitle, String anchorPrefix, MessageArea extMessageArea) {
		super(leftContent, rightContent, tabTitle, anchorPrefix, extMessageArea);
	}
	
	public void show(boolean isNewRule) {
		this.isNewRule = isNewRule;
		if (isNewRule) {
			currentIndex = 0;
			updateWizardDisplay();
		}
		else {
			enableAllTabs();
			showAllCommonBottomWidgets();
			nextButton.setVisible(false);
			prevButton.setVisible(false);
		}
	}
	
	public boolean validateAllItems() {
		boolean result = true;
		int numTabs = getNumTabs();
		for (int i = 0; i < numTabs; i++) {
			Widget currentContent = this.getResizableTab(tabTitlesList.get(i)).getTabContent();
			if (currentContent instanceof TabItem) {
				TabItem currentTabItem = (TabItem) currentContent;
				if (!currentTabItem.validate()) {
					result = false;
				}
			}
		}
		return result;
	}

	public boolean validateCurrentTabItem() {
		boolean isCurrentTabItemValid = true;

		Widget currentContent = this.getResizableTab(tabTitlesList.get(currentIndex)).getTabContent();
		if (currentContent instanceof TabItem) {
			isCurrentTabItemValid = ((TabItem) currentContent).validate();
		}
		
		return isCurrentTabItemValid;
	}
	
	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer#addTab(com.google.gwt.user.client.ui.Widget, java.lang.String)
	 */
	@Override
	public void addTab(Widget content, String tabTitle) {
		super.addTab(content, tabTitle);
		if (tabTitlesList == null) {
			tabTitlesList = new ArrayList<String>();
		}
		tabTitlesList.add(tabTitle);
	}

	public void addCommonBottomWidget(Widget widget) {
		if (widget != null) {
			commonButtonsPanel.add(widget);
		}
	}
	
	protected ButtonWidget createPrevButton() {
		ButtonWidget button = new ButtonWidget(rulesConstants.prevLink());
		button.setText(rulesConstants.prevLink());
		button.setVisible(false);
		button.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		button.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				currentIndex--;
				updateWizardDisplay();
			}
		});
		return button;
	}

	private ButtonWidget createNextButton() {
		ButtonWidget button = new ButtonWidget(rulesConstants.nextLink());
		button.setText(rulesConstants.nextLink());
		button.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		button.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				if (validateCurrentTabItem()) {
					currentIndex++;
					highestVisitedIndex = Math.max(currentIndex, highestVisitedIndex);
					updateWizardDisplay();
				}
			}
		});
		return button;
	}
	
	protected void updateWizardDisplay() {
		int numTabs = getNumTabs();
		if (currentIndex <= 0) {
			prevButton.setVisible(false);
			nextButton.setVisible(true);
		} else if (currentIndex < numTabs - 1) {
			prevButton.setVisible(true);
			nextButton.setVisible(true);
		} else if (currentIndex >= numTabs - 1) {
			showAllCommonBottomWidgets();
			prevButton.setVisible(true);
			nextButton.setVisible(false);
		}
		disableYetToBeVisitedTabs(currentIndex, highestVisitedIndex);
		
		tabContainer.selectTab(currentIndex);
	}

	protected void disableAllButFirstTab() {
		int numTabs = getNumTabs();
		for (int i = 0; i < numTabs; i++) {
			boolean enabled = false;
			if (i == 0) {
				enabled = true;
			}
			setTabEnabled(i, enabled);
		}
	}
	
	protected void disableYetToBeVisitedTabs(int currentIndex, int highestVisitedIndex) {
		int numTabs = getNumTabs();
		for (int i = 0; i < numTabs; i++) {
			boolean enabled = false;
			if (i <= highestVisitedIndex) {
				enabled = true;
			}
			setTabEnabled(i, enabled);
		}
	}

	protected void enableAllTabs() {
		int numTabs = getNumTabs();
		for (int i = 0; i < numTabs; i++) {
			boolean enabled = true;
			setTabEnabled(i, enabled);
		}
	}

	protected void showAllCommonBottomWidgets() {
		for (int i = 0; i < commonButtonsPanel.getWidgetCount(); i++) {
			Widget widget = commonButtonsPanel.getWidget(i);
			widget.setVisible(true);
		}
	}
	
	private void setTabEnabled(int index, boolean enabled) {
		if (tabContainer.getTabBar().isVisible()) {
			tabContainer.getTabBar().setTabEnabled(index, enabled);
		}		
	}
	
	private int getNumTabs() {
		return tabContainer.getTabBar().getTabCount();
	}
}
