package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaModeSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;

/**
 * TODO: this should be merged in together with ValidationCriteriaPanel
 * 
 * @author rchu
 * 
 */
public class TitleFilterPanel extends VerticalPanel implements Validatable, HasSelectionHandlers<UiCriteriaMode> {

	private CriteriaListingPanel titleFilterPanel;
	private CriteriaModeSelector modeSelector;

	public TitleFilterPanel(UIRuleSet ruleSet) {
		IUITitleFilterNode root = ruleSet.getTitleFilter().getRootNode();
		BaseOperator op = new BaseOperator();
		titleFilterPanel = new CriteriaListingPanel(UiCriteriaMode.EPISODE, root, op);
		add(titleFilterPanel);
	}
	
	public TitleFilterPanel(SelectionHandler<UiCriteriaMode> critModeHandler, UIRuleSet ruleSet) {
		addSelectionHandler(critModeHandler);
		modeSelector = new CriteriaModeSelector();
		if(!ruleSet.isNew()) {
			  modeSelector.setValue(ruleSet.getTitleFilter().getCriteriaMode());
			  modeSelector.setLocked(true);
		}
		modeSelector.addSelectionHandler(new SelectionHandler<UiCriteriaMode>() {
			
			@Override
			public void onSelection(SelectionEvent<UiCriteriaMode> event) {
				titleFilterPanel.setCriteriaMode(event.getSelectedItem());
				titleFilterPanel.resetCriteria();
				SelectionEvent.fire(TitleFilterPanel.this, event.getSelectedItem());
			}
		});
		IUITitleFilterNode root = ruleSet.getTitleFilter().getRootNode();
		BaseOperator op = new BaseOperator();
		titleFilterPanel = new CriteriaListingPanel(modeSelector.getValue(), root, op);
		
		add(modeSelector);
		add(titleFilterPanel);
	}

	@Override
	public boolean validate() {
		boolean result = this.titleFilterPanel.validate();
		if(modeSelector != null && result)
			modeSelector.setLocked(true);
		return result;
	}

	/**
	 * Grab information from the title panel UI, but this will need to be merged
	 * in to be similar to validation panel
	 * 
	 * @param criteriaList
	 * @return
	 */
	public UITitleFilter getTitleFilter() {
		UITitleFilter filter = new UITitleFilter();
		UITitleFilterListNode tree = new UITitleFilterListNode();
		if(modeSelector != null)
			filter.setCriteriaMode(modeSelector.getValue());
		PredicateList root = titleFilterPanel.getRoot();
		if (root.isVisible())
			titleFilterPanel.populateTree(tree, root);
		filter.setRootNode(tree);
		return filter;
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<UiCriteriaMode> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}
}
