/**
 * File Name	:	EventSchedulePanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 16, 2011 3:23:03 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class ValidatableVerticalPanel extends VerticalContainer implements
		Validatable {
	
	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable#validate()
	 */
	@Override
	public boolean validate() {
		boolean validateResult = true;
		WidgetCollection children = this.getChildren();
		for (int i = 0; i < children.size(); i++) {
			Widget childWidget = children.get(i);
			if (childWidget instanceof Validatable) {
				Validatable validatableChildWidget = (Validatable) childWidget;
				if (!validatableChildWidget.validate()) {
					validateResult = false;
				}
			}
		}
		return validateResult;
	}

}
