package com.tandbergtv.cms.rules.ui.client.common.customrules;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.rules.ui.client.data.customrules.DisplayCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;

public class CustomRuleBox extends VerticalPanel {

	private TextBoxWidget textBox = new TextBoxWidget();
	private CustomRuleSelector selector;
	private String className;
	private UiCustomRuleTree dtoTree;
	private CustomRuleParameterPanel crpp;
	private SimplePanel crppContainer = new SimplePanel();

	public CustomRuleBox(UiCustomRuleTree tree) {
		super();
		this.dtoTree = tree;
		add(textBox);
		add(crppContainer);
		textBox.setReadOnly(true);
		textBox.setVisibleLength(100);
		textBox.addStyleName("black-txt");
		textBox.addStyleName("small-txt");
		textBox.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if (selector == null && className == null) {
					selector = new CustomRuleSelector(dtoTree);
					selector.addSelectionHandler(getSelectionHandler());
				} else if (selector == null) {
					selector = new CustomRuleSelector(dtoTree, className);
					selector.addSelectionHandler(getSelectionHandler());
				}
				int x = textBox.getAbsoluteLeft();
				int y = textBox.getAbsoluteTop();
				selector.show(x, y);
			}

			private SelectionHandler<DisplayCustomRule> getSelectionHandler() {
				return new SelectionHandler<DisplayCustomRule>() {

					@Override
					public void onSelection(
							SelectionEvent<DisplayCustomRule> event) {
						DisplayCustomRule rule = event.getSelectedItem();
						textBox.setValue(rule.getDisplayName());
						setClassName(rule.getClassName());
						crppContainer.clear();
						if(rule.getParameters().size() > 0) {
							crpp = new CustomRuleParameterPanel(rule.getParameters());
							crppContainer.setWidget(crpp);
						} else {
							crpp = null;
						}
					}

				};
			}

		});
	}

	public CustomRuleBox(UiCustomRuleTree tree, UiCustomRule rule) {
		this(tree);
		setClassName(rule.getClassName());
		DisplayCustomRule cr = lookUpDisplayName(className, tree);
		if(cr != null) {
			textBox.setValue(cr.getDisplayName());
			crppContainer.clear();
			if(cr.getParameters().size() > 0) {
				crppContainer.clear();
				crpp = new CustomRuleParameterPanel(cr.getParameters(), rule.getParameters());
				crppContainer.setWidget(crpp);
			}
		}
	}

	private DisplayCustomRule lookUpDisplayName(String className, UiCustomRuleTree tree) {
		if (tree.getCustomRules() != null
				&& tree.getCustomRules().getClassName().equals(className)) {
			return tree.getCustomRules();
		} else {
			for(UiCustomRuleTree node : tree.getNodes()) {
				DisplayCustomRule cr = lookUpDisplayName(className, node);
				if(cr  != null) {
					return cr;
				}
			}
		}
		return null;
	}

	private void setClassName(String className) {
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

	public List<UiCustomRuleParameter> getParameters() {
		if(crpp == null)
			return new ArrayList<UiCustomRuleParameter>();
		return crpp.getValues();
	}
	
	public boolean validate() {
		boolean valid = true;
		if(textBox.getText().isEmpty()) {
			textBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
			textBox.addChangeHandler(new ChangeHandler() {

				@Override
				public void onChange(ChangeEvent event) {
					if (textBox.getText().isEmpty()) {
						textBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
					} else {
						textBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
					}
				}

			});
			valid = false;
		}
		
		if(crpp != null && !crpp.validate()) {
			valid = false;
		} 
		return valid;  
	}
}
