package com.tandbergtv.cms.rules.ui.client.common.customrules;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueDateBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiDisplayCustRuleParam;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiDisplayCustRuleParam.VariableDataType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

public class CustomRuleParameterPanel extends SimplePanel {

	private FlexTable parameters;
	private List<String> keys = new ArrayList<String>();

	public CustomRuleParameterPanel(List<UiDisplayCustRuleParam> fields) {
		this(fields, new ArrayList<UiCustomRuleParameter>());
	}

	public CustomRuleParameterPanel(List<UiDisplayCustRuleParam> fields,
			List<UiCustomRuleParameter> values) {
		parameters = new FlexTable();
		parameters.setBorderWidth(1);
		parameters.setCellPadding(2);
		parameters.setCellSpacing(0);
		setWidget(parameters);

		for (int i = 0; i < fields.size(); i++) {
			UiDisplayCustRuleParam var = fields.get(i);
			parameters.setWidget(i, 0, new LabelWidget(var.getDisplayName()));
			SingleValueWidget valWid = null;
			if (values.size() > i && !values.get(i).getValue().isEmpty()) {
				valWid = buildWidget(var.getDataType(), values.get(i)
							.getValue());
			} else {
				valWid = buildWidget(var.getDataType());
			}
			keys.add(var.getKey());
			parameters.setWidget(i, 1, valWid);
		}
	}

	private SingleValueWidget buildWidget(VariableDataType dataType,
			String value) {
		switch (dataType) {
		case INTEGER:
			return new ValueTextBox(new LongValidator(Integer.MIN_VALUE,
					Integer.MAX_VALUE), value);
		case LONG:
			return new ValueTextBox(new LongValidator(), value);
		case BOOLEAN:
			return new ValueBooleanBox(value);
		case FLOAT:
			return new ValueTextBox(new FloatValidator(), value);
		case DATE:
			return new ValueDateBox(value);
		case TIME:
			return new ValueTextBox(new TimeValidator(), value);
		default:
			return new ValueTextBox(new StringValidator(), value);
		}
	}

	private SingleValueWidget buildWidget(VariableDataType dataType) {
		switch (dataType) {
		case INTEGER:
			return new ValueTextBox(new LongValidator(Integer.MIN_VALUE,
					Integer.MAX_VALUE));
		case LONG:
			return new ValueTextBox(new LongValidator());
		case BOOLEAN:
			return new ValueBooleanBox();
		case FLOAT:
			return new ValueTextBox(new FloatValidator());
		case DATE:
			return new ValueDateBox();
		case TIME:
			return new ValueTextBox(new TimeValidator());
		default:
			return new ValueTextBox(new StringValidator());
		}
	}

	public boolean validate() {
		int size = parameters.getRowCount();
		boolean result = true;
		for (int i = 0; i < size; i++) {
			if (!((SingleValueWidget) parameters.getWidget(i, 1)).validate())
				result = false;
		}
		return result;
	}

	public List<UiCustomRuleParameter> getValues() {
		int size = parameters.getRowCount();
		List<UiCustomRuleParameter> values = new ArrayList<UiCustomRuleParameter>();
		for (int i = 0; i < size; i++) {
			String value = ((SingleValueWidget) parameters.getWidget(i, 1))
					.getValue();
			values.add(new UiCustomRuleParameter(keys.get(i), value));
		}
		return values;
	}
}
