package com.tandbergtv.cms.rules.ui.client.common.customrules;

import java.util.List;

import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.rules.ui.client.data.customrules.DisplayCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;

public class CustomRuleSelector extends PopupContainer implements HasSelectionHandlers<DisplayCustomRule> {
	private static final int BOX_HEIGHT_INT = 200;

	private ScrollPanel scrollPanel = new ScrollPanel();
	private Tree tree;

	public CustomRuleSelector(UiCustomRuleTree dtoTree) {
		super(true, true);
		buildTree(dtoTree);
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {

			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				TreeItem si = event.getSelectedItem();
				if(si.getUserObject() != null) {
					DisplayCustomRule selectedItem = (DisplayCustomRule) si.getUserObject();
					SelectionEvent.fire(CustomRuleSelector.this, selectedItem);
					hide();
				}
			}
			
		});
		scrollPanel.setSize("600px", "200px");
		scrollPanel.setWidget(tree);
		setWidget(scrollPanel);
	}
	
	public CustomRuleSelector(UiCustomRuleTree dtoTree, String className) {
		this(dtoTree);
		setSelectItem(className);
	}

	private void setSelectItem(String className) {
		for(int i =0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if (item.getUserObject() != null
					&& ((DisplayCustomRule) item.getUserObject())
							.getClassName().equals(className)) {
				tree.setSelectedItem(item,false);
				tree.ensureSelectedItemVisible();
				break;
			} else {
				setSelectedItem(className, item);
			}
		}
	}
	
	private void setSelectedItem(String className, TreeItem item) {
		for(int i =0; i < item.getChildCount(); i++) {
			TreeItem child = item.getChild(i);
			if (child.getUserObject() != null
					&& ((DisplayCustomRule) child.getUserObject())
							.getClassName().equals(className)) {
				tree.setSelectedItem(child,false);
				tree.ensureSelectedItemVisible();
				break;
			} else {
				setSelectedItem(className, child);
			}
		}
	}

	private void buildTree(UiCustomRuleTree dtoTree) {
		tree = new TreeWidget();
		if(dtoTree.getName().isEmpty()) {
			for(UiCustomRuleTree condition : dtoTree.getNodes()) {
				TreeItem item = new TreeItem(condition.getName());
				item.setUserObject(condition.getCustomRules());
				buidTree(item, condition.getNodes());
				tree.addItem(item);
			}
		} else {
			TreeItem item = new TreeItem(dtoTree.getName());
			item.setUserObject(dtoTree.getCustomRules());
			buidTree(item, dtoTree.getNodes());
			tree.addItem(item);
		}
	}
	
	private void buidTree(TreeItem item, List<UiCustomRuleTree> nodes) {
		for(UiCustomRuleTree condition : nodes) {
			TreeItem childItem = new TreeItem(condition.getName());
			childItem.setUserObject(condition.getCustomRules());
			buidTree(childItem, condition.getNodes());
			item.addItem(childItem);
		}
	}

	public void show(final int x, final int y) {
		setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				int height = Window.getClientHeight();
				int yOffset = 0;
				if (y + BOX_HEIGHT_INT > height)
					yOffset = BOX_HEIGHT_INT;
				setPopupPosition(x, y - yOffset);
			}
		});
	}
	
	public DisplayCustomRule getSelectedRule() {
		return (DisplayCustomRule) tree.getSelectedItem().getUserObject();
	}
	
	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<DisplayCustomRule> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}

}