package com.tandbergtv.cms.rules.ui.client.common.rulelisting;

import java.util.List;

import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIMsoRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable.OrderableTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

/**
 * Rules listing panel to show the listing, allow users to get details of row
 * 
 * @author rchu
 * 
 */
public class RulesListingPanel extends RulesListingPanelBase {

	private static final String STYLE_NAME_ID_CELL = "rules-list-col-id";
	private static final String STYLE_NAME_ENABLED_CELL = "rules-list-col-enabled";
	private static final String STYLE_NAME_RULESET_NAME_CELL = "rules-list-col-ruleSetName";
	private static final String STYLE_NAME_SITES_CELL = "rules-list-col-Sites";
	private static final String STYLE_NAME_UPDATE_DATE_CELL = "rules-list-col-updateDate";
	private static final String STYLE_NAME_UUID_CELL = "rules-list-col-UUID";
	private static final String STYLE_NAME_SITES_STRING = "rules-list-sitesString";
	
	/**
	 * creates listing panel based on package type
	 * 
	 * @param packages
	 * @param serviceLoader
	 * @param security
	 */
	public RulesListingPanel(Packages packages) {
		super(packages, packages.equals(Packages.NORMALIZATION) || packages.equals(Packages.MSOOVERRIDE), true);
	}

	/*
	 * Setup a rules listing panel
	 */
	protected OrderableTable createTable(boolean isOrderable) {
		NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
		boolean hasChkBox = security.isUserInRole(Permissions.MODIFY) || security.isUserInRole(Permissions.DELETE);
		
		// create table and add the columns and buttons
		OrderableTable tbl = new OrderableTable("id", isOrderable, hasChkBox, 0);
		tbl.addColumn(constants.ruleListViewRuleSetId(), "id");
		tbl.addColumn(constants.enabledLabel(), "enabled");
		tbl.addColumn(constants.ruleListViewRuleSetName(), "name");
		if(Packages.MSOOVERRIDE.equals(this.pkgType)) {
			tbl.addColumn(constants.mso(), "mso");
		} else if (!(Packages.LICENSING.equals(this.pkgType)) && RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
			tbl.addColumn(constants.sitesLabel(), "site");
		} 
		tbl.addColumn(constants.updateDate(), "updateDate");
		tbl.addColumn(constants.uuid(), "uuid");
		return tbl;
	}

	protected void createAndAddButtons() {
		super.createAndAddButtons();
	}

	protected void populateTable(OrderableTable table, List<UIRuleListItem> result) {
		for (int i = 0; i < result.size(); i++) {
			UIRuleListItem item = result.get(i);
			try {
				ImageWidget enabledImage = getEnabledImage(item
						.isEnabled());

				HTMLWidget id = new HTMLWidget("" + item.getId());
				HTMLWidget name = new HTMLWidget(item.getName());
				HTMLWidget uuid = new HTMLWidget(item.getUuid());
				HTMLWidget updateDate = new HTMLWidget(item
						.getUpdateDate());

				id.addClickHandler(getDetailHandler(item.getId()));
				name.addClickHandler(getDetailHandler(item.getId()));

				id.setStyleName(TableConstants.STYLE_DATA_LINK);
				name.setStyleName(TableConstants.STYLE_DATA_LINK);

				table.addItem(i, "id", id, STYLE_NAME_ID_CELL);
				table.addItem(i, "enabled", enabledImage, STYLE_NAME_ENABLED_CELL);
				table.addItem(i, "name", name, STYLE_NAME_RULESET_NAME_CELL);
				if(Packages.MSOOVERRIDE.equals(this.pkgType)) {
					HTMLWidget msos = new HTMLWidget(RulesUtils.getNamesString(((UIMsoRuleListItem)item).getMsos()));
					msos.addStyleName(STYLE_NAME_SITES_STRING);
					table.addItem(i, "mso", msos, STYLE_NAME_SITES_CELL);
				} else if (!(Packages.LICENSING.equals(this.pkgType)) && RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
					HTMLWidget sites = new HTMLWidget(RulesUtils.getNamesString(item.getSites()));
					sites.addStyleName(STYLE_NAME_SITES_STRING);
					table.addItem(i, "site", sites, STYLE_NAME_SITES_CELL);
				}
				table.addItem(i, "updateDate", updateDate, STYLE_NAME_UPDATE_DATE_CELL);
				table.addItem(i, "uuid", uuid, STYLE_NAME_UUID_CELL);
			} catch (Exception e) {
				// exception probably means back column name
				String msg = "Error populating table: ";
				setErrorMessage(msg + e.getMessage());
			}
		}
	}
}
