package com.tandbergtv.cms.rules.ui.client.common.site;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class SiteSelectionPanel extends VerticalPanel {

	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private VerticalPanel siteOptions = new VerticalPanel();
	private SiteSelector sitePanel;
	private CheckBox local;
	private CheckBox global;

	private NeptuneSecurity security;

	public SiteSelectionPanel() {
		super();
		sitePanel = new SiteSelector();
		buildUI(false);
	}

	public SiteSelectionPanel(List<UISite> sites, boolean isGlobal) {
		super();
		sitePanel = new SiteSelector(sites);
		security = NeptuneApplication.getApplication().getSecurity();
		final boolean localEnabled = security.isUserInRole("Sites_Modify");
		buildUI(sitePanel.getSelectedSites().size() > 0);
		global.setValue(isGlobal);
		local.setEnabled(localEnabled && (sites.size() > 0));
	}

	private void buildUI(boolean showLocal) {
		global = new CheckBox(myConstants.global());

		local = new CheckBox(myConstants.local());
		local.setValue(showLocal);
		local.addValueChangeHandler(new ValueChangeHandler<Boolean>() {

			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				sitePanel.setVisible(local.getValue());
			}

		});
		siteOptions.add(global);
		siteOptions.add(local);
		add(siteOptions);

		security = NeptuneApplication.getApplication().getSecurity();
		final boolean localEnabled = security.isUserInRole("Sites_Modify");

		add(sitePanel);
		sitePanel.setVisible(local.getValue());
		addStyleName("site-selection-panel");
		sitePanel.registerSiteLoadedEvent(new SitesLoadedHandler() {

			@Override
			public void loadedSites(SitesLoadedEvent event) {
				if(!event.hasSites()) {
					global.setValue(true);
				}
				local.setEnabled(localEnabled && event.hasSites());
			}
			
		});

	}
	
	public boolean isRunOnGlobal() {
		return global.getValue();
	}

	public List<UISite> getSites() {
		if(local.getValue())
			return sitePanel.getSelectedSites();
		else
			return new ArrayList<UISite>();
	}

	public boolean containsGlobalAndSite() {
		List<UISite> sites = sitePanel.getSelectedSites();
		return global.getValue() && (local.getValue() && sites.size() > 0);
	}
}
