package com.tandbergtv.cms.rules.ui.client.common.site;

import com.google.gwt.event.shared.GwtEvent;

public class SitesLoadedEvent extends GwtEvent<SitesLoadedHandler> {
	public static final Type<SitesLoadedHandler> TYPE = new Type<SitesLoadedHandler>();
	
	private boolean hasSites;
	
	public SitesLoadedEvent(boolean hasSites) {
		setHasSites(hasSites);
	}
	
	@Override
	protected void dispatch(SitesLoadedHandler handler) {
		handler.loadedSites(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<SitesLoadedHandler> getAssociatedType() {
		return TYPE;
	}

	public void setHasSites(boolean hasSites) {
		this.hasSites = hasSites;
	}

	public boolean hasSites() {
		return hasSites;
	}
}