package com.tandbergtv.cms.rules.ui.client.common.site;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.HasName;

public class UISite implements IsSerializable, HasName {
	private int id;
	private String name;
	private List<UISite> children = new ArrayList<UISite>();
	private SiteType siteType;
	private boolean active;
	private boolean selected;
	
	public UISite() {
		
	}

	public UISite(int id, String name, SiteType siteType,  boolean active) {
		super();
		setId(id);
		setName(name);
		setSiteType(siteType);
		setActive(active);
	}
	
	public UISite(int id, String name, SiteType siteType,  boolean active, boolean selected) {
		this(id, name, siteType, active);
		setSelected(selected);
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setChildren(List<UISite> children) {
		this.children = children;
	}

	public List<UISite> getChildren() {
		return children;
	}

	public void setSiteType(SiteType siteType) {
		this.siteType = siteType;
	}

	public SiteType getSiteType() {
		return siteType;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	public boolean isActive() {
		return active;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public boolean isSelected() {
		return selected;
	}
}
