package com.tandbergtv.cms.rules.ui.client.common.site;

import java.io.Serializable;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

public class UiRuleSetsAssocWJobExpception extends NeptuneException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private List<UiRuleSetJobsAssoc> issues;

	public UiRuleSetsAssocWJobExpception() {
		super();
	}

	public UiRuleSetsAssocWJobExpception(List<UiRuleSetJobsAssoc> issues) {
		this();
		setIssues(issues);
	}

	public void setIssues(List<UiRuleSetJobsAssoc> issues) {
		this.issues = issues;
	}

	public List<UiRuleSetJobsAssoc> getIssues() {
		return issues;
	}

	public static class UiRuleSetJobsAssoc implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		private String siteName;
		private String jobNames;
		
		public UiRuleSetJobsAssoc() {
			this("", "");
		}

		public UiRuleSetJobsAssoc(String siteName, String jobNames) {
			super();
			this.setSiteName(siteName);
			setJobNames(jobNames);
		}

		public String getJobNames() {
			return jobNames;
		}

		public void setJobNames(String jobNames) {
			this.jobNames = jobNames;
		}

		public void setSiteName(String siteName) {
			this.siteName = siteName;
		}

		public String getSiteName() {
			return siteName;
		}

	}
}
