package com.tandbergtv.cms.rules.ui.client.contentprocessing;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcherAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.SchedulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;
import com.tandbergtv.cms.rules.ui.client.common.ValidatableVerticalPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 *  This is the contents processing rule set details page.
 * @author dweiner
 *
 */
public class ContentProcessingRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private RuleNamePanel ruleNamePanel;
	private TitleFilterPanel panelTitleFilter;
	private ProcessingRulePanel processingPanel;
	private EventSelectPanel panelEventSelect;
	private BusyIndicator busyIndicator = new BusyIndicator();
	private SiteSelectionPanel siteSelectionPanel;
	private SchedulePanel schedulePanel;

	public ContentProcessingRuleSetPanel() {
		super();
	}

	@Override
	protected void createPanel() {
		busyIndicator.center();
		if(!ProcessingRulePanel.cachedLoaded()) {
			getAvailableActions();
			getAvailableTemplates();
		} else {
			populateUi();
		}
	}
	
	/**
	 * builds all the UI objects and adds them to the container.
	 */
	private void populateUi() {
		setStyleName("rule-panel");
		setHeaderLabel();
		
		resetMessagePanel();
		setHeaderLabel();

		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());
		panelEventSelect = new EventSelectPanel(ruleSet);
		panelTitleFilter = new TitleFilterPanel(ruleSet);
		processingPanel = new ProcessingRulePanel(ruleSet.getRules());

		schedulePanel = new SchedulePanel(ruleSet.getScheduleInfo());

		NeptuneSecurity security = RulesComponent.getInstance().getSecurity();

		boolean canCreateSchedule = security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE);
		boolean canViewSchedule = security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW);
		boolean canEditSchedule = security.isUserInRole(Permissions.MODIFY)
				&& security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT);
		boolean canDeleteSchedule = security.isUserInRole(Permissions.MODIFY)
				&& security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.DELETE);

		boolean isScheduleVisible = ((ruleSet.getScheduleInfo() == null) && canCreateSchedule)
				|| canViewSchedule || canEditSchedule || canDeleteSchedule;
		boolean isScheduleCheckBoxEnabled = ((ruleSet.getScheduleInfo() == null) && canCreateSchedule)
				|| ((ruleSet.getScheduleInfo() != null) && canDeleteSchedule);
		boolean isScheduleEnabled = ((ruleSet.getScheduleInfo() == null) && canCreateSchedule)
				|| canEditSchedule;

		schedulePanel.setScheduleEnabled(isScheduleEnabled);
		schedulePanel.setCheckBoxEnabled(isScheduleCheckBoxEnabled);

		// If there is a schedule associated with this rule set, but user 
		//	does not have permissions to view the schedule, 
		//	display an error message to the user. 
		
		if ((ruleSet.getScheduleInfo() != null) && !isScheduleVisible) {
			showErrorMessage(myConstants.msgScheduleButCannotShow());
		}
		
		WizardPane collapseEventSelect = new WizardPane(panelEventSelect,
				myConstants.wizardEventSelection(), isScheduleVisible ? true
						: false);
		WizardPane collapseSchedule = new WizardPane(schedulePanel, myConstants.wizardScheduleSelection(), true);
		
		ValidatableVerticalPanel eventScheduleContainer = new ValidatableVerticalPanel();
		eventScheduleContainer.add(collapseEventSelect);
		if (isScheduleVisible) {
			eventScheduleContainer.add(collapseSchedule);
		}

		TabItem whenToRunTabItem = new TabItem(myConstants.eventScheduleWizInstruct(), eventScheduleContainer);
		TabItem titleFilterTabItem = new TabItem(myConstants.wizFilterInstruct(), panelTitleFilter);
		TabItem cpRuleTabItem = new TabItem(myConstants.contProcRuleInstruct(), processingPanel);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);
		
		if(RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
			if(ruleSet.isNew() && ruleSet.getSites().isEmpty()) {
				siteSelectionPanel = new SiteSelectionPanel();
			} else {
				siteSelectionPanel = new SiteSelectionPanel(ruleSet.getSites(), ruleSet.isRunOnGlobal());
			}
			TabItem siteSelectionTabItem = new TabItem(myConstants.siteSelectInstructions(), siteSelectionPanel);
			tabbedWizard = new TabbedWizard(siteSelectionTabItem, myConstants.sitesLabel(), "");
			tabbedWizard.addTab(whenToRunTabItem, myConstants.wizardEventSchedule());
		}
		else {
			tabbedWizard = new TabbedWizard(whenToRunTabItem, myConstants.wizardEventSchedule(), "");
		}
		
		tabbedWizard.addTab(titleFilterTabItem, myConstants.wizardTitleFilter());
		tabbedWizard.addTab(cpRuleTabItem, myConstants.wizardProcessing());
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);
		
		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		
		tabbedWizard.addCommonBottomWidget(saveButton);

		tabbedWizard.addCommonBottomWidget(cancelButton);

		tabbedWizard.show(ruleSet.isNew());

		this.registerMessageListener(tabbedWizard);
		schedulePanel.registerMessageListener(tabbedWizard);

		FieldSelector.getTree(CriteriaType.SEARCH_CONDITION_LHS, UiCriteriaMode.EPISODE);
		busyIndicator.hide();
	}

	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {
				if(!tabbedWizard.validateAllItems())
					return;
				// create rule set from various panels
				final ButtonWidget button = (ButtonWidget) event.getSource();
				UIRuleSet ruleset = new UIRuleSet();
				ruleset.setId(ruleSet.getId());
				ruleset.setEnabled(ruleNamePanel.isEnabled());
				ruleset.setName(ruleNamePanel.getRuleName());
				if(siteSelectionPanel != null) {
					ruleset.setRunOnGlobal(siteSelectionPanel.isRunOnGlobal());
					ruleset.setSites(siteSelectionPanel.getSites()); 
				}
				ruleset.setPackageId(Packages.PROCESSING);
				ruleset.setEvents(panelEventSelect.getEvents());
				boolean isSchedulerLicensed = RulesUtils.isSchedulerLicensed();
				if (isSchedulerLicensed) {
					ruleset.setScheduleInfo(schedulePanel.getScheduleInfo());
				}
				ruleset.setRules(processingPanel.getRules());
				ruleset.setTitleFilter(panelTitleFilter.getTitleFilter());
				button.setEnabled(false);
				
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
							handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
						} else if (caught instanceof UiInvalidScheduleException) {
							UiInvalidScheduleException uise = (UiInvalidScheduleException) caught;
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages(uise);
							schedulePanel.clearWarningMessages();
							schedulePanel.addWarningMessages(messages);
						}  else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}
					@Override
					public void onNeptuneSuccess(Integer result) {
						//Send back to ruleListingPanel
						resetMessagePanel();
						button.setEnabled(true);
						History.back();
					}
				});
			}
		};
	}

	private void setHeaderLabel() {
		String newRule = myConstants.newContentProcessingRule();
		String oldRule = myConstants.contentProcessingRuleDetails() + " " + ruleSet.getName();
		String headerString = (ruleSet.getName().equals(""))?  newRule : oldRule;
		setHeaderLabel(headerString);
	}
	
	/**
	 * ProcessingRulePanel has a couple of cached items
	 * that need to be loaded asynchronously. As each one completes
	 * it notifies me by calling this method.  I know when I done
	 * when ProcessingRulePanel.cachedLoaded() returns true. 
	 */
	private void notifyDoneWithAsync() {
		if (ProcessingRulePanel.cachedLoaded()) {
			populateUi();
		}
	}
	
	/**
	 * Load the processing action from the server
	 */
	private void getAvailableActions() {
		UiActionServiceAsync actionService = GWT.create(UiActionService.class);
		actionService.getActions(Packages.PROCESSING,
				new NeptuneAsyncCallback<List<UIAction>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						Window.alert(caught == null ? "" : caught
								.getMessage());
					}

					@Override
					public void onNeptuneSuccess(List<UIAction> result) {
						if(result != null && result.size() == 1) {
							ProcessingRulePanel.setCachedBlankAction(result.get(0));
							notifyDoneWithAsync();
						} else {
							Window.alert("ERROR: There should only be one action available for Content Processing.");
							busyIndicator.hide();
						}
					}

				});
	}
	
	/**
	 * Load the available workflow templates asynchronously
	 */
	private void getAvailableTemplates() {
		UiRulesTemplateFetcherAsync templateFetcherService = GWT.create(UiRulesTemplateFetcher.class);
		templateFetcherService.getTemplates(new NeptuneAsyncCallback<List<UiWorkflowTemplate>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				Window.alert(caught == null ? "" : caught
						.getMessage());
			}

			@Override
			public void onNeptuneSuccess(List<UiWorkflowTemplate> result) {
				ProcessingRulePanel.setCachedAvailableTemplates(result);
				notifyDoneWithAsync();
			}
			
		});
		
	}

	@Override
	protected void onUnload(){
		super.onUnload();
		//we always hide on unLoad
		busyIndicator.hide();
	}

}
