package com.tandbergtv.cms.rules.ui.client.contentprocessing;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * This is the ui component which represents a rule within
 * a content processing rule set.  Currently a content processing
 * rule set contains only one rule.
 * @author dweiner
 *
 */
public class ProcessingRulePanel extends VerticalContainer implements Validatable {
	
	private ListBoxWidget<UiWorkflowTemplate> templates = new ListBoxWidget<UiWorkflowTemplate>();
	private UiRule rule;
	private MessageContainer messageContainer = new MessageContainer();
	private static List<UiWorkflowTemplate> availableTemplates;
	/*I go to the server once and get the blank copy of the action. I mostly
	 * do this for consistency sake.  Basically we can have only one action with one parameter for
	 * content processing.
	 * Action: Start Template
	 * Parameter: templateName
	*/
	private static UIAction blankAction;

	public ProcessingRulePanel(List<UiRule> rules) {
		if(rules != null && rules.size() == 1) {
			this.rule = rules.get(0);
		}
		putUiTogether();
	}
	
	private void putUiTogether() {
		//load the avalailable templates
		templates = new ListBoxWidget<UiWorkflowTemplate>();
		for(UiWorkflowTemplate  template : availableTemplates) {
			templates.addItem(template.getTemplateName(), template);
		}
		
		if(rule != null && rule.getActions().size() == 1) {
			UIAction action = rule.getActions().get(0);
			if(action.containsParam(ActionParams.TEMPLATENAME)) {
				UIActionParam param = action.getParam(ActionParams.TEMPLATENAME);
				String templateName = param.getValue();
				boolean foundTemplate = false;
				for(UiWorkflowTemplate template : availableTemplates) {
					if(template.getTemplateName().equals(templateName)) {
						templates.setSelectedItem(template);
						foundTemplate = true;
						break;
					}
				}
				if(!foundTemplate) {
					templates.insertItem("", null,0);
					templates.setSelectedIndex(0);
					RulesMessages ruleMessages = (RulesMessages) GWT.create(RulesMessages.class);
					messageContainer.addErrorMessage(ruleMessages.templateNotFound(templateName), true);
				}
			}
		}
		add(messageContainer);
		add(templates);
	}

	public List<UiRule> getRules() {
		List<UiRule> result = new ArrayList<UiRule>();
		UiRule newRule = new UiStandardRule();
		newRule.setActions(getActions());
		if(rule != null)
			newRule.setId(rule.getId());
		result.add(newRule);
		return result;
	}
	
	private List<UIAction> getActions() {
		List<UIAction> result = new ArrayList<UIAction>();
		UIAction action = blankAction.clone();
		
		if(action.containsParam(ActionParams.TEMPLATENAME)) {
			UIActionParam param = action.getParam(ActionParams.TEMPLATENAME);
			param.setValue(templates.getSelectedItem().getTemplateName());
		}
		result.add(action);
		return result;
	}

	public static void setCachedAvailableTemplates(List<UiWorkflowTemplate> availableTemplates) {
		ProcessingRulePanel.availableTemplates = availableTemplates;
	}

	public static void setCachedBlankAction(UIAction blankAction) {
		ProcessingRulePanel.blankAction = blankAction;
	}

	/**
	 * Returns true if the cached items are loaded. Specifically this is concerning
	 * the action and available templates.
	 * @return Returns true if the cached items are loaded.
	 */
	public static boolean cachedLoaded() {
		return blankAction != null &&  availableTemplates != null;
	}

	@Override
	public boolean validate() {
		if(templates.getSelectedItem() == null) {
			RulesConstants myConstants = (RulesConstants) GWT.create(RulesConstants.class);
			messageContainer.addErrorMessage(myConstants.selectTemplate(), true);
			return false;
		}
		return true;
	}
}
