package com.tandbergtv.cms.rules.ui.client.contentprocessing;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI object for representing a workflow template that can
 * be selected from a content processing rule.
 * @author dweiner
 *
 */
public class UiWorkflowTemplate implements IsSerializable{
	
	private String templateName;
	
	/**
	 * Default Constructor
	 */
	public UiWorkflowTemplate() {
		
	}
	
	/**
	 * Constructor
	 * @param templateName the template name
	 */
	public UiWorkflowTemplate(String templateName) {
		this.setTemplateName(templateName);
	}

	/**
	 * @param templateName the templateName to set
	 */
	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}

	/**
	 * @return the templateName
	 */
	public String getTemplateName() {
		return templateName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return 31 + ((templateName == null) ? 0 : templateName.hashCode());
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!(obj instanceof UiWorkflowTemplate))
			return false;
		UiWorkflowTemplate other = (UiWorkflowTemplate) obj;
		if (templateName == null)
			return (other.templateName == null);
		return templateName.equals(other.templateName);
	}
	
}
