package com.tandbergtv.cms.rules.ui.client.data;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Case does not matter but the string version of each item in the enum must
 * match the action class name it represents minus the word "actions" i.e.
 * "VALIDATION" matches "ValidationActions"
 */

public enum Packages implements IsSerializable {
	VALIDATION("Validation"), NORMALIZATION("Normalization"), TARGETING(
			"Targeting"), PROCESSING("Processing"), PRIORITIZATION("Prioritization"), LICENSING("Licensing"), MSOOVERRIDE("MsoOverride");

	private String key;

	Packages(String key) {
		this.key = key;
	}

	public static Packages lookup(String packageName) {
		Packages[] allOper = Packages.values();
		for (Packages oper : allOper) {
			if (oper.key.equalsIgnoreCase(packageName))
				return oper;
		}
		throw new java.lang.IllegalArgumentException("No value found for "
				+ packageName);
	}

	public String toString() {
		return key;
	}
}
