package com.tandbergtv.cms.rules.ui.client.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;

public class UIAction implements IsSerializable, Comparable<UIAction> {

	private String action;
	private String labelKey;
	private String[] xpathFilter;
	private int actionId = -1;
	private Map<String, UIActionParam> paramMap = new HashMap<String, UIActionParam>();
	// I store in a list also so I can remember the order of the params.
	private List<UIActionParam> params = new ArrayList<UIActionParam>();
	private Map<String, UIDataType> valueTypeMap;
	private boolean useSuggestedValues;
	private boolean matchedOnly;
	private boolean allowMatchedRootNodes;
	private boolean allowAssets;
	private String[] assetTypesAllowed;
	private String[] assetTypesDisallowed;
	private UIFieldType[] fieldTypesAllowed;

	// private String method;

	public UIAction() {
		super();
	}

	public UIAction(String action) {
		this.action = action;
	}

	public UIAction(String action, int actionId) {
		this.action = action;
		this.actionId = actionId;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * @param actionId
	 *            the actionId to set
	 */
	public void setActionId(int actionId) {
		this.actionId = actionId;
	}

	/**
	 * @return the actionId
	 */
	public int getActionId() {
		return actionId;
	}

	public void addParam(String name, String labelName, String value,
			String type) {
		UIActionParam param = new UIActionParam(name, labelName, value, type);
		paramMap.put(name, param);
		params.add(param);
	}

	public void addParam(String name, String value) {
		UIActionParam param = new UIActionParam(name, value);
		paramMap.put(name, param);
		params.add(param);
	}

	public UIActionParam getParam(ActionParams paramName) {
		return paramMap.get(paramName.getName());
	}

	public List<UIActionParam> getAllParams() {
		return params;
	}

	public boolean containsParam(ActionParams paramName) {
		return paramMap.containsKey(paramName.getName());
	}

	public void SetParamValue(ActionParams paramName, String value) {
		if (containsParam(paramName))
			paramMap.get(paramName).setValue(value);
	}

	public void setLabelKey(String labelKey) {
		this.labelKey = labelKey;
	}

	public String getLabelKey() {
		return labelKey;
	}

	public boolean allowsField(UIFieldType fieldType, String assetType, String xpath) {
		boolean passesAllowAssets = (xpath != null && !xpath.isEmpty()) || this.allowAssets;
		boolean passesAllowedAsset = this.assetTypesAllowed == null || assetTypesAllowed.length == 0;
		boolean passesDisAllowedAsset = true;
		boolean passesXpathFilter = this.xpathFilter == null || xpathFilter.length == 0;
		boolean passesAllowedFieldType = false;
		
		if (this.xpathFilter != null) {
			for (int i = 0; i < xpathFilter.length; i++) {
				if (xpathFilter[i].equals(xpath)) {
					passesXpathFilter = true;
					break;
				}
			}
		}

		for(UIFieldType fieldTypeAllowed : fieldTypesAllowed) {
			if (fieldType.equals(fieldTypeAllowed)) {
				if(passesXpathFilter && !fieldType.equals(UIFieldType.ASSET)) {
					return true;
				}
				passesAllowedFieldType = true;
				break;
			}
		}
		
		if (this.assetTypesAllowed != null) {
			for(String assetAllowed : assetTypesAllowed) {
				if (assetType.matches(assetAllowed)) {
					passesAllowedAsset = true;
					break;
				}
			}
		}
		
		if (this.assetTypesDisallowed != null) {
			for(String assetDisallowed : assetTypesDisallowed) {
				if (assetType.matches(assetDisallowed)) {
					passesDisAllowedAsset = false;
					break;
				}
			}
		}

		return passesAllowAssets && passesAllowedFieldType && passesAllowedAsset && passesDisAllowedAsset && passesXpathFilter;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof UIAction) {
			String otherAction = ((UIAction) obj).action;
			return this.action.equals(otherAction);
		}
		return false;
	}

	public UIAction clone() {
		UIAction result = new UIAction();
		result.action = this.action;
		result.actionId = this.actionId;
		result.labelKey = this.labelKey;
		// Don't need to do a deep copy of the value type parameter because it
		// should never change
		result.valueTypeMap = valueTypeMap;
		result.paramMap = new HashMap<String, UIActionParam>();
		result.params = new ArrayList<UIActionParam>();
		result.assetTypesAllowed = assetTypesAllowed;
		result.assetTypesDisallowed = assetTypesAllowed;
		for (UIActionParam param : this.params) {
			UIActionParam newParam = param.clone();
			result.paramMap.put(param.getName(), newParam);
			result.params.add(newParam);
		}
		if (this.xpathFilter != null) {
			result.xpathFilter = new String[this.xpathFilter.length];
			for (int i = 0; i < xpathFilter.length; i++) {
				result.xpathFilter[i] = this.xpathFilter[i];
			}
		}
		return result;
	}

	public void setValueTypeMap(Map<String, UIDataType> valueTypeMap) {
		this.valueTypeMap = valueTypeMap;
	}

	public Map<String, UIDataType> getValueTypeMap() {
		return valueTypeMap;
	}

	public void setXpathFilter(String[] xpathFilter) {
		this.xpathFilter = xpathFilter;
	}

	public String[] getXpathFilter() {
		return xpathFilter;
	}

	@Override
	public int compareTo(UIAction uiAction) {
		// used to put actions in lexicographical order
		return labelKey.compareToIgnoreCase(uiAction.labelKey);
	}

	public boolean useSuggestedValues() {
		return useSuggestedValues;
	}

	public void setUseSuggestedValues(boolean useSuggestedValues) {
		this.useSuggestedValues = useSuggestedValues;
	}

	public void setMatchOnly(boolean matchedOnly) {
		this.matchedOnly = matchedOnly;

	}

	public boolean isMatchOnly() {
		return matchedOnly;
	}

	public void setAllowMatchedRootNodes(boolean allowMatchedRootNodes) {
		this.allowMatchedRootNodes = allowMatchedRootNodes;
	}

	public boolean getAllowMatchedRootNodes() {
		return this.allowMatchedRootNodes;
	}

	public void setAssetTypesDisallowed(String[] assetTypesDisallowed) {
		this.assetTypesDisallowed = assetTypesDisallowed;
	}

	public void setAssetTypesAllowed(String[] assetTypesAllowed) {
		this.assetTypesAllowed = assetTypesAllowed;
	}

	/**
	 * @return the assetTypesAllowed
	 */
	public String[] getAssetTypesAllowed() {
		return assetTypesAllowed;
	}

	/**
	 * @return the assetTypesDisallowed
	 */
	public String[] getAssetTypesDisallowed() {
		return assetTypesDisallowed;
	}

	public void setFieldTypesAllowed(UIFieldType[] fieldTypesAllowed) {
		this.fieldTypesAllowed = fieldTypesAllowed;
	}
	
	public UIFieldType[] getAllowedFieldTypes() {
		return fieldTypesAllowed;
	}

	public boolean allowAssets() {
		return allowAssets;
	}

	public void setAllowAssets(boolean allowAssets) {
		this.allowAssets = allowAssets;
	}
}
