package com.tandbergtv.cms.rules.ui.client.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;

public class UIMSORuleSet extends UIRuleSet {

	private Set<Integer> msoIds;

	/**
	 * 
	 */
	public UIMSORuleSet() {
		super();
		setMsoIds(new HashSet<Integer>());
		setPackageId(Packages.MSOOVERRIDE);
	}

	public UIMSORuleSet(List<UiRule> rules, String name, boolean isEnabled,
			List<UIEvent> events, IUITitleFilterNode tree,
			Set<Integer> msos) {
		super(rules, name, isEnabled, events, tree, new ArrayList<UISite>());
		this.setMsoIds(msos);
		setPackageId(Packages.MSOOVERRIDE);
	}

	public Set<Integer> getMsoIds() {
		return msoIds;
	}

	public void setMsoIds(Set<Integer> msoIds) {
		this.msoIds = msoIds;
	}
}
