package com.tandbergtv.cms.rules.ui.client.data;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;

public class UIRuleSet implements IsSerializable {

	private List<UiRule> rules;
	private String name = "";
	private List<UIEvent> events;
	private UITitleFilter uiRetListNode = new UITitleFilter();
	private int id=-1;
	private int version= -1;
	private Packages packageId;
	private boolean isEnabled;
	private boolean runOnGlobal;
	private List<UISite> sites;
	private ScheduleInfo scheduleInfo;

	public UIRuleSet() {
		super();
		this.events = new ArrayList<UIEvent>();
		this.rules = new ArrayList<UiRule>();
		this.sites = new ArrayList<UISite>();
		//Default is Enabled
		isEnabled = true;
		runOnGlobal = true;
	}
	
	public UIRuleSet(List<UiRule> rules, String name, boolean isEnabled, List<UIEvent> events,
			IUITitleFilterNode tree, List<UISite> sites) {
		super();
		this.rules = rules;
		this.name = name;
		this.events = events;
		this.isEnabled = isEnabled;
		this.uiRetListNode.setRootNode(tree);
		setSites(sites);
	}

	public UIRuleSet(List<UISite> sites, boolean runOnGlobal) {
		this();
		setRunOnGlobal(runOnGlobal);
		setSites(sites);
	}

	/**
	 * @param rules
	 *            the rules to set
	 */
	public void setRules(List<UiRule> rules) {
		this.rules = rules;
	}

	/**
	 * @return the rules
	 */
	public List<UiRule> getRules() {
		return this.rules;
	}

	/**
	 * @param ruleName
	 *            the ruleName to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the ruleName
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param events
	 *            the events to set
	 */
	public void setEvents(List<UIEvent> events) {
		this.events = events;
	}

	/**
	 * @return the events
	 */
	public List<UIEvent> getEvents() {
		return events;
	}

	public boolean isNew() {
		return id==-1;
		
	}
	
	public int getId() {
		return this.id;
	}

	public void setId(int ruleSetId) {
		this.id = ruleSetId;
		
	}
	
	public void addEvent(UIEvent uiEvent) {
		if(events == null) {
			events = new ArrayList<UIEvent>();
		}
		events.add(uiEvent);
	}
	

	public void addRule(UiRule uiRule) {
		if(rules == null) {
			rules = new ArrayList<UiRule>();
		}
		rules.add(uiRule);
		
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(int version) {
		this.version = version;
	}

	/**
	 * @return the version
	 */
	public int getVersion() {
		return version;
	}

	/**
	 * @param categoryId the categoryId to set
	 */
	public void setPackageId(Packages packageId) {
		this.packageId = packageId;
	}

	/**
	 * @return the categoryId
	 */
	public Packages getPackageId() {
		return packageId;
	}
	
	public void setTitleFilter(UITitleFilter titleFilter) {
		uiRetListNode = titleFilter;
	}
	
	public UITitleFilter getTitleFilter() {
		return uiRetListNode;
	}

	public void setEnabled(boolean isEnabled) {
		this.isEnabled = isEnabled;
	}

	public boolean isEnabled() {
		return isEnabled;
	}

	public void setRunOnGlobal(boolean runOnGlobal) {
		this.runOnGlobal = runOnGlobal;
	}

	public boolean isRunOnGlobal() {
		return runOnGlobal;
	}

	public void setSites(List<UISite> sites) {
		this.sites = sites;
	}

	public List<UISite> getSites() {
		return sites;
	}

	/**
	 * @return the scheduleInfo
	 */
	public ScheduleInfo getScheduleInfo() {
		return scheduleInfo;
	}

	/**
	 * @param scheduleInfo the scheduleInfo to set
	 */
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		this.scheduleInfo = scheduleInfo;
	}
	
}
