package com.tandbergtv.cms.rules.ui.client.data;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public abstract class UiRule implements IsSerializable {
	protected int id;
	protected List<UIAction> actions;

	public UiRule() {
		super();
		id = -1;
	}
	
	public UiRule(List<UIAction> actions) {
		this();
		setActions(actions);
	}
	
	public UiRule(int id, List<UIAction> actions) {
		super();
		setId(id);
		setActions(actions);
	}

	public abstract UiRuleType getRuleType();

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	public void setActions(List<UIAction> actions) {
		this.actions = actions;
	}

	public List<UIAction> getActions() {
		return actions;
	}
}
