package com.tandbergtv.cms.rules.ui.client.data.customrules;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiRuleType;

public class UiCustomRule extends UiRule implements IsSerializable {

	private String className;
	private List<UiCustomRuleParameter> parameters;

	public UiCustomRule() {
		super();
	}
	
	public UiCustomRule(String className, List<UiCustomRuleParameter> parameters) {
		this(-1, className, parameters);
	}
	
	public UiCustomRule(int id, String className, List<UiCustomRuleParameter> parameters) {
		setId(id);
		setClassName(className);
		setActions(new ArrayList<UIAction>());
		setParameters(parameters);
	}
	
	public UiCustomRule(List<UIAction> actions, String className, List<UiCustomRuleParameter> parameters) {
		this(-1, actions, className, parameters);
	}

	public UiCustomRule(int id, List<UIAction> actions, String className, List<UiCustomRuleParameter> parameters) {
		super(id, actions);
		setClassName(className);
		setParameters(parameters);
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

	@Override
	public UiRuleType getRuleType() {
		return UiRuleType.CUSTOM_RULE;
	}

	public void setParameters(List<UiCustomRuleParameter> parameters) {
		this.parameters = parameters;
	}

	public List<UiCustomRuleParameter> getParameters() {
		return parameters;
	}
}
