package com.tandbergtv.cms.rules.ui.client.data.customrules;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiCustomRuleTree implements IsSerializable {
	private String name;
	private List<UiCustomRuleTree> nodes = new ArrayList<UiCustomRuleTree>();
	private DisplayCustomRule customRules;

	public UiCustomRuleTree() {
		this("");
	}

	public UiCustomRuleTree(String name) {
		setName(name);
	}

	public boolean isLeaf() {
		return getNodes().size() == 0;
	}

	public void setCustomRule(DisplayCustomRule customRules) {
		this.customRules = customRules;
	}

	public DisplayCustomRule getCustomRules() {
		return customRules;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void addRule(DisplayCustomRule rule) {
		String[] tokens = rule.getDisplayName().split("\\.");
		addRule(rule, tokens, 0);
	}

	private void addRule(DisplayCustomRule rule, String[] tokens, int pos) {
		if (pos == tokens.length) {
			setCustomRule(rule);
		} else {
			boolean found = false;
			int nextPos = pos + 1;
			for (UiCustomRuleTree node : getNodes()) {
				if (node.name.equals(tokens[pos])) {
					node.addRule(rule, tokens, nextPos);
					found = true;
					break;
				}
			}

			if (!found) {
				getNodes().add(buildBranch(rule, tokens, pos));
			}
		}
	}

	private UiCustomRuleTree buildBranch(DisplayCustomRule rule,
			String[] tokens, int pos) {
		UiCustomRuleTree branch = new UiCustomRuleTree(tokens[pos++]);
		UiCustomRuleTree currBranch = branch;
		while (pos < tokens.length) {
			UiCustomRuleTree temp = new UiCustomRuleTree(tokens[pos++]);
			currBranch.getNodes().add(temp);
			currBranch = temp;
		}
		currBranch.setCustomRule(rule);
		return branch;
	}

	public List<UiCustomRuleTree> getNodes() {
		return nodes;
	}
}
