package com.tandbergtv.cms.rules.ui.client.licenseassignment;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProvider;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProviderAsync;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

public class LicAssignmentRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private RuleNamePanel ruleNamePanel;
	private LicensingRule rulePanel;
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private BusyIndicator busyIndicator = new BusyIndicator();

	protected List<UiLicense> availableLicenses;

	public LicAssignmentRuleSetPanel() {
		super();
	}

	@Override
	protected void createPanel() {
		busyIndicator.center();
		/* before we can populate ui make sure we load asynchronous data first.
		 * if it is not already loaded*/
		if(!LicensingRule.cachedLoaded())
			getAvailableActions();
		getAvailableLicenses();
	}

	private void populateUi() {
		setStyleName("rule-panel");

		resetMessagePanel();
		setHeaderLabel();
		
		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());

		UiStandardRule rule = null;
		if(!ruleSet.isNew())
			rule = (UiStandardRule) ruleSet.getRules().get(0);
		rulePanel = new LicensingRule(availableLicenses, rule);
		
		TabItem licRuleTabItem = new TabItem(myConstants.licensingCriteriaInstructions(), rulePanel);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);

		tabbedWizard = new TabbedWizard(licRuleTabItem, myConstants.wizardLicensingCriteria(), "");
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);
		
		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		
		tabbedWizard.addCommonBottomWidget(saveButton);
		tabbedWizard.addCommonBottomWidget(cancelButton);

		tabbedWizard.show(ruleSet.isNew());
		
		this.registerMessageListener(tabbedWizard);

		FieldSelector.getTree(CriteriaType.RULE_CONDITION_LHS_LICRULE, UiCriteriaMode.EPISODE);
		busyIndicator.hide();
	}

	/**
	 * Load the processing action from the server
	 */
	private void getAvailableActions() {
		UiActionServiceAsync actionService = GWT.create(UiActionService.class);
		actionService.getActions(Packages.LICENSING,
				new NeptuneAsyncCallback<List<UIAction>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						Window.alert(caught == null ? "" : caught.getMessage());
					}

					@Override
					public void onNeptuneSuccess(List<UIAction> result) {
						if (result != null && result.size() == 1) {
							LicensingRule.setCachedBlankAction(result
									.get(0));
							notifyDoneWithAsync();
						} else {
							Window.alert("ERROR: There should only be one action available for Licensing Assignment.");
							busyIndicator.hide();
						}
					}

				});
	}
	
	/**
	 * Load the available licenses asynchronously
	 */
	private void getAvailableLicenses() {
		UiLicenseDataProviderAsync licFetcher = GWT.create(UiLicenseDataProvider.class);
		licFetcher.getAvailableLicenses(new NeptuneAsyncCallback<List<UiLicense>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				Window.alert(caught == null ? "" : caught
						.getMessage());
			}

			@Override
			public void onNeptuneSuccess(List<UiLicense> result) {
				availableLicenses = result;
				notifyDoneWithAsync();
			}
			
		});
		
	}
	
	private void setHeaderLabel() {
		String newRule = "Create New Licensing Assignment Rule Set";
		String oldRule = "Licensing Assignment Rule Set Details: " + ruleSet.getName();
		String headerString = (ruleSet.getName().equals(""))?  newRule : oldRule;
		setHeaderLabel(headerString);
	}
	
	/**
	 * ProcessingRulePanel has a couple of cached items
	 * that need to be loaded asynchronously. As each one completes
	 * it notifies me by calling this method.  I know when I done
	 * when ProcessingRulePanel.cachedLoaded() returns true. 
	 */
	private void notifyDoneWithAsync() {
		if (LicensingRule.cachedLoaded() && availableLicenses != null) {
			populateUi();
		}
	}
	
	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {

				if(!tabbedWizard.validateAllItems())
					return;

				final ButtonWidget button = (ButtonWidget) event.getSource();
				// create rule set from various panels
				UIRuleSet ruleset = new UIRuleSet();
				ruleset.setId(ruleSet.getId());
				ruleset.setEnabled(ruleNamePanel.isEnabled());
				ruleset.setName(ruleNamePanel.getRuleName());
				ruleset.setRunOnGlobal(true);
				ruleset.setPackageId(Packages.LICENSING);
				ruleset.setTitleFilter(new UITitleFilter());
				List<UiRule> rules = new ArrayList<UiRule>(1);
				rules.add(rulePanel.getRule());
				ruleset.setRules(rules);
				button.setEnabled(false);
				
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
							handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
						}  else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}
					@Override
					public void onNeptuneSuccess(Integer result) {
						// go back to rules lisitng page
						resetMessagePanel();
						button.setEnabled(true);
						History.back();
					}
				});
			}
		};
	}

}
