package com.tandbergtv.cms.rules.ui.client.licenseassignment;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

public class LicensingRule extends CriteriaListingPanel implements IRuleForm {

	private static UIAction blankAction;
	private List<UiLicense> availableLicenses;
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private int ruleId = -1;
	private ListBoxWidget<Long> licenses = new ListBoxWidget<Long>();

	public LicensingRule(List<UiLicense> availableLicenses,
			UiStandardRule rule) {
		super(UiCriteriaMode.EPISODE);
		if(rule != null)
			this.ruleId = rule.getId();
		this.operatorProvider = new RulesOperatorFull();
		this.availableLicenses = availableLicenses;
		putTheUiTogether(rule);
	}

	/**
	 * @param contentClasses
	 */
	public LicensingRule() {
		super(UiCriteriaMode.EPISODE);
		this.operatorProvider = new RulesOperatorFull();
		putTheUiTogether(null);
	}

	private void putTheUiTogether(UiStandardRule rule) {

		getContainer().add(super.getWarningMessageBox());
		// show text: "when this is true:"
		getContainer().add(new Label(myConstants.validationActionLabel()));
		
		IUITitleFilterNode node = null;
		if(rule != null)
			node = rule.getUiTitleFilterNode();
		initializeTree(node); // Put the Tree in

		Long licId = null;
		if(rule != null) {
			//there should only be one action. It is basically hard coded.
			UIActionParam param = rule.getActions().get(0).getParam(ActionParams.LICID);
			licId = Long.parseLong(param.getValue());
		}

		// action selection row
		for(UiLicense license : availableLicenses) {
			if(!license.isAlreadyUsed() || (licId != null && license.getId().equals(licId)))
				licenses.addItem(license.getName(), license.getId());
		}
		
		if(licId != null)
			licenses.setSelectedItem(licId);

		getContainer().add(new Label(myConstants.licenseToAssign()));
		getContainer().add(licenses);
		
		
		// SET STYLES
		getContainer().setStyleName(CRITERIA_PANEL_CONTAINER_STYLE);
		setStyleName(CRITERIA_PANEL_STYLE);
	}

	@Override
	public UiRule getRule() {
		UITitleFilterListNode tree = getCriteria();
		UIAction action = blankAction.clone();
		UIActionParam param = action.getParam(ActionParams.LICID);
		param.setValue(licenses.getSelectedItem().toString());
		
		List<UIAction> actions = new ArrayList<UIAction>();
		actions.add(action);
		return new UiStandardRule(ruleId, tree, actions);
	}

	@Override
	public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
		return addHandler(handler, RuleDeleteEvent.TYPE);
	}

	/**
	 * Returns true if the cached items are loaded. Specifically this is
	 * concerning the action and available templates.
	 * 
	 * @return Returns true if the cached items are loaded.
	 */
	public static boolean cachedLoaded() {
		return blankAction != null;
	}

	public static void setCachedBlankAction(UIAction blankAction) {
		LicensingRule.blankAction = blankAction;
	}
	
	@Override
	public boolean validate() {
		boolean result = super.validate();
		if(licenses.getSelectedItem() == null) {
			addWarningMessage("Please select a License");
			result = false;
		}
		return result;
	}
	


	@Override
	public CriteriaType getLhsCriteriaType() {
		CriteriaType critType = CriteriaType.SEARCH_CONDITION_LHS;
		if (operatorProvider instanceof RulesOperatorLimited)
			critType = CriteriaType.RULE_CONDITION_LHS_LICRULE;
		return critType;
	}

	@Override
	public CriteriaType getRhsCriteriaType() {
		return CriteriaType.CONDITION_RHS_LICRULE;
	}
}
