package com.tandbergtv.cms.rules.ui.client.msooverride;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIMSORuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * This class represnts a RuleSet creation/editing page within the UI
 * @author dweiner
 *
 */
public class MsoOverrideRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private TitleFilterPanel panelTitleFilter;
	private MsoPanel msoPanel;
	private NormalizationRulePanel normPanel;
	private RuleNamePanel ruleNamePanel;
	private BusyIndicator busyIndicator = new BusyIndicator();
		
	public MsoOverrideRuleSetPanel() {
		super();
	}
	
	@Override
	protected void onUnload(){
		super.onUnload();
		busyIndicator.hide();
	}
	
	@Override
	protected void createPanel() {
		busyIndicator.center();
		if(!NormalizationActionBox.cacheLoaded())
			loadNormalizationActionsAsync();
		else
			populateUi();
	}
	
	private void populateUi() {
		setStyleName("rule-panel");
		
		resetMessagePanel();
		setHeaderLabel();
		
		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());		
		panelTitleFilter = new TitleFilterPanel(ruleSet);
		normPanel = new NormalizationRulePanel(ruleSet.getRules(), true);

		msoPanel = new MsoPanel(((UIMSORuleSet)ruleSet).getMsoIds());

		// If there is a schedule associated with this rule set, but user 
		//	does not have permissions to view the schedule, 
		//	display an error message to the user. 
		
		TabItem titleFilterTabItem = new TabItem(myConstants.wizFilterInstruct(), panelTitleFilter);
		TabItem normRuleTabItem = new TabItem(myConstants.msoRuleInstruct(), normPanel);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);
		TabItem msoTabItem = new TabItem(myConstants.msoSelectPanelInstructions(), msoPanel);
		tabbedWizard = new TabbedWizard(msoTabItem, myConstants.mso(), "");
		tabbedWizard.addTab(titleFilterTabItem, myConstants.wizardTitleFilter());
		tabbedWizard.addTab(normRuleTabItem, myConstants.wizardNormalization());
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);
		
		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		
		tabbedWizard.addCommonBottomWidget(saveButton);
		
		tabbedWizard.addCommonBottomWidget(cancelButton);

		tabbedWizard.show(ruleSet.isNew());

		this.registerMessageListener(tabbedWizard);
		
		FieldSelector.initialize(CriteriaType.RULE_CONDITION_LHS, UiCriteriaMode.EPISODE);
		FieldSelector.initialize(CriteriaType.SEARCH_CONDITION_LHS, UiCriteriaMode.EPISODE);
		busyIndicator.hide();
	}

	@Override
	public void setRule(final UIRuleSet ruleSet) {
		/* The standard path always passes a new UIRuleSet because that always
		 * worked in the past but I need a new UIMSORuleSet so I'll ensure it here.
		 */
		if(ruleSet.isNew())
			this.ruleSet = new UIMSORuleSet();
		else
			this.ruleSet = ruleSet;
		load();
	}

	/**
	 * performs necessary async call to load cached data
	 */
	private void loadNormalizationActionsAsync() {
		UiActionServiceAsync actionService = GWT.create(UiActionService.class);
		actionService.getActions(Packages.NORMALIZATION,
				new NeptuneAsyncCallback<List<UIAction>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						Window.alert(caught == null ? "" : caught.getMessage());
					}

					@Override
					public void onNeptuneSuccess(List<UIAction> result) {
						NormalizationActionBox.setActionsListCache(result);
						populateUi();
					}
				});
	}

	/**
	 * A click handler that kicks of an asynchronous save.
	 * On success the user is returned to the rule listing page.
	 * 
	 * @return The click handler.
	 */
	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {
				resetMessagePanel();
				if(!tabbedWizard.validateAllItems()) {
					return;
				}
				final ButtonWidget button = (ButtonWidget) event.getSource();
				UIRuleSet ruleset = buildRuleSet();
				button.setEnabled(false);
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
							handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
						} else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}

					@Override
					public void onNeptuneSuccess(Integer result) {
						resetMessagePanel();
						button.setEnabled(true);
						//Send back to ruleListingPanel
						History.back();
					}
				});
			}
		};
	}
	
	/**
	 * Builds a rule set the represents what is currently displayed on the page.
	 * 
	 * @return The rule set to be saved.
	 */
	private UIRuleSet buildRuleSet() {
		// create rule set from various panels
		UIMSORuleSet ruleset = new UIMSORuleSet();
		ruleset.setId(ruleSet.getId());
		ruleset.setEnabled(ruleNamePanel.isEnabled());
		ruleset.setName(ruleNamePanel.getRuleName());
		ruleset.setRunOnGlobal(false);
		ruleset.setPackageId(Packages.MSOOVERRIDE);
		ruleset.setMsoIds(msoPanel.getSelectedMsos());
		ruleset.setRules(normPanel.getRules());
		ruleset.setTitleFilter(panelTitleFilter.getTitleFilter());
		return ruleset;
	}

	private void setHeaderLabel() {
		String newRule = myConstants.newMsoOverrideRule();
		String oldRule = myConstants.msoOverrideDetails() + " " + ruleSet.getName() ;
		String header = (ruleSet.getName().equals("")) ? newRule : oldRule;
		setHeaderLabel(header);
	}

}
