package com.tandbergtv.cms.rules.ui.client.msooverride;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcherAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;

/**
 * This widget that will display msos as a list of checkboxes and allow them to be selected.
 * @author Daniel Weiner
 *
 */
public class MsoPanel extends VerticalPanel implements Validatable, IMessageEmitter {

	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private BusyIndicator busyIndicator = new BusyIndicator();
	private UiRulesSiteFetcherAsync siteFetcher = GWT.create(UiRulesSiteFetcher.class);
	
	private VerticalPanel msoSelectPanel = new VerticalPanel();
	private IMessageListener messageListener; 

	public MsoPanel(final Set<Integer> selectedMsos) {
		busyIndicator.center();
		siteFetcher.getMsos(new NeptuneAsyncCallback<List<UiMso>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				RulesComponent.getInstance().getCurrentTab().setPanelInError(myConstants.errLoadingMsos());
				busyIndicator.hide();
			}

			@Override
			public void onNeptuneSuccess(List<UiMso> msos) {
				for(UiMso mso : msos)
					msoSelectPanel.add(new MsoCheckBox(mso, selectedMsos.contains(mso.getId())));
				buildUi();
				busyIndicator.hide();
			}
		});
	}
	
	public void buildUi() {
		HorizontalPanel checkPanel = new HorizontalPanel();
		String labelText = myConstants.siteSelectLabel();
		HTML checkLabel = new HTML("<div style=\"margin-right: 5px;\">"
				+ labelText + "</div>");
		checkPanel.add(checkLabel);
		checkPanel.add(buildCheckWidget(myConstants.all(), true));
		checkPanel.add(buildCheckWidget(myConstants.none(), false));
		add(checkPanel);
		add(msoSelectPanel);
	}

	@Override
	public boolean validate() {
		if(getSelectedMsos().size() == 0) {
			messageListener.setErrorMessage(myConstants.mustSelectMSO());
			return false;
		}
		messageListener.reset();
		return true;
	}

	/**
	 * 
	 * @return the list of selected MSOs 
	 */
	public Set<Integer> getSelectedMsos() {
		Set<Integer> results = new HashSet<Integer>();
		for(int i = 0; i < msoSelectPanel.getWidgetCount(); i++) {
			MsoCheckBox checkBox = (MsoCheckBox)msoSelectPanel.getWidget(i);
			if(checkBox.getValue()) 
				results.add(checkBox.getId());
		}
		return results;
	}

	/**
	 * A little wrapper for the checkbox so that I can store the id for the mso also.
	 * @author Daniel Weiner
	 *
	 */
	private class MsoCheckBox extends CheckBox {

		private int id;
		
		public MsoCheckBox(UiMso mso, boolean checked) {
			super(mso.getName());
			this.id = mso.getId();
			this.setValue(checked);
		}

		public int getId() {
			return id;
		}
	}
	
	private Label buildCheckWidget(String text, final boolean checked) {
		Label label = new Label(text);
		label.setStyleName("site-selector-check-all");
		label.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				for(int i = 0; i < msoSelectPanel.getWidgetCount(); i++)
					((MsoCheckBox)msoSelectPanel.getWidget(i)).setValue(checked);
			}

		});
		return label;

	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
	}

}
